/*
 * Decompiled with CFR 0.152.
 */
package kotlin.uuid;

import java.io.Serializable;
import java.util.Comparator;
import kotlin.ULong;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.HexExtensionsKt;
import kotlin.text.StringsKt;
import kotlin.uuid.UuidKt__UuidKt;

public final class Uuid
implements Serializable {
    public static final Companion Companion = new Companion(null);
    private final long mostSignificantBits;
    private final long leastSignificantBits;
    private static final Uuid NIL = new Uuid(0L, 0L);
    private static final Comparator<Uuid> LEXICAL_ORDER = Uuid::LEXICAL_ORDER$lambda$2;

    public Uuid(long mostSignificantBits, long leastSignificantBits) {
        this.mostSignificantBits = mostSignificantBits;
        this.leastSignificantBits = leastSignificantBits;
    }

    public String toString() {
        byte[] bytes = new byte[36];
        UuidKt__UuidKt.access$formatBytesInto(this.leastSignificantBits, bytes, 24, 6);
        bytes[23] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.leastSignificantBits >>> 48, bytes, 19, 2);
        bytes[18] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits, bytes, 14, 2);
        bytes[13] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits >>> 16, bytes, 9, 2);
        bytes[8] = 45;
        UuidKt__UuidKt.access$formatBytesInto(this.mostSignificantBits >>> 32, bytes, 0, 4);
        return StringsKt.decodeToString(bytes);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Uuid)) {
            return false;
        }
        return this.mostSignificantBits == ((Uuid)other).mostSignificantBits && this.leastSignificantBits == ((Uuid)other).leastSignificantBits;
    }

    public int hashCode() {
        long x = this.mostSignificantBits ^ this.leastSignificantBits;
        return (int)(x >> 32) ^ (int)x;
    }

    private static final int LEXICAL_ORDER$lambda$2(Uuid a, Uuid b) {
        return a.mostSignificantBits != b.mostSignificantBits ? Long.compareUnsigned(ULong.constructor-impl(a.mostSignificantBits), ULong.constructor-impl(b.mostSignificantBits)) : Long.compareUnsigned(ULong.constructor-impl(a.leastSignificantBits), ULong.constructor-impl(b.leastSignificantBits));
    }

    public static final class Companion {
        private Companion() {
        }

        public final Uuid getNIL() {
            return NIL;
        }

        public final Uuid fromLongs(long mostSignificantBits, long leastSignificantBits) {
            return mostSignificantBits == 0L && leastSignificantBits == 0L ? this.getNIL() : new Uuid(mostSignificantBits, leastSignificantBits);
        }

        public final Uuid parse(String uuidString) {
            boolean bl;
            Intrinsics.checkNotNullParameter(uuidString, "uuidString");
            boolean bl2 = bl = uuidString.length() == 36;
            if (!bl) {
                boolean bl3 = false;
                String string = "Expected a 36-char string in the standard uuid format.";
                throw new IllegalArgumentException(string.toString());
            }
            long part1 = HexExtensionsKt.hexToLong$default(uuidString, 0, 8, null, 4, null);
            UuidKt__UuidKt.access$checkHyphenAt(uuidString, 8);
            long part2 = HexExtensionsKt.hexToLong$default(uuidString, 9, 13, null, 4, null);
            UuidKt__UuidKt.access$checkHyphenAt(uuidString, 13);
            long part3 = HexExtensionsKt.hexToLong$default(uuidString, 14, 18, null, 4, null);
            UuidKt__UuidKt.access$checkHyphenAt(uuidString, 18);
            long part4 = HexExtensionsKt.hexToLong$default(uuidString, 19, 23, null, 4, null);
            UuidKt__UuidKt.access$checkHyphenAt(uuidString, 23);
            long part5 = HexExtensionsKt.hexToLong$default(uuidString, 24, 36, null, 4, null);
            long msb = part1 << 32 | part2 << 16 | part3;
            long lsb = part4 << 48 | part5;
            return this.fromLongs(msb, lsb);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

