/*
 * Decompiled with CFR 0.152.
 */
package kotlin.coroutines.jvm.internal;

import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.jvm.internal.BaseContinuationImpl;
import kotlin.coroutines.jvm.internal.CompletedContinuation;
import kotlin.jvm.internal.Intrinsics;

public abstract class ContinuationImpl
extends BaseContinuationImpl {
    private final CoroutineContext _context;
    private transient Continuation<Object> intercepted;

    public ContinuationImpl(Continuation<Object> completion, CoroutineContext _context) {
        super(completion);
        this._context = _context;
    }

    public ContinuationImpl(Continuation<Object> completion) {
        Continuation<Object> continuation = completion;
        this(completion, continuation != null ? continuation.getContext() : null);
    }

    @Override
    public CoroutineContext getContext() {
        CoroutineContext coroutineContext = this._context;
        Intrinsics.checkNotNull(coroutineContext);
        return coroutineContext;
    }

    public final Continuation<Object> intercepted() {
        Continuation<Object> continuation = this.intercepted;
        if (continuation == null) {
            Continuation continuation2;
            Object object = (ContinuationInterceptor)this.getContext().get(ContinuationInterceptor.Key);
            if (object == null || (object = object.interceptContinuation(this)) == null) {
                object = this;
            }
            Continuation it = continuation2 = object;
            boolean bl = false;
            this.intercepted = it;
            continuation = continuation2;
        }
        return continuation;
    }

    @Override
    protected void releaseIntercepted() {
        Continuation<Object> intercepted = this.intercepted;
        if (intercepted != null && intercepted != this) {
            Object e = this.getContext().get(ContinuationInterceptor.Key);
            Intrinsics.checkNotNull(e);
            ((ContinuationInterceptor)e).releaseInterceptedContinuation(intercepted);
        }
        this.intercepted = CompletedContinuation.INSTANCE;
    }
}

