/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.DPIZoomChangeRegistry;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class CommonWidgetsDPIChangeHandlers {
    public static void registerCommonHandlers() {
        DPIZoomChangeRegistry.registerHandler(CommonWidgetsDPIChangeHandlers::handleItemDPIChange, Item.class);
        DPIZoomChangeRegistry.registerHandler(CommonWidgetsDPIChangeHandlers::handleStyledTextDPIChange, StyledText.class);
        DPIZoomChangeRegistry.registerHandler(CommonWidgetsDPIChangeHandlers::handleCComboDPIChange, CCombo.class);
    }

    private static void handleItemDPIChange(Widget widget, int newZoom, float scalingFactor) {
        if (!(widget instanceof Item)) {
            return;
        }
        Item item = (Item)widget;
        Image image = item.getImage();
        if (image != null) {
            item.setImage(image);
        }
    }

    private static void handleStyledTextDPIChange(Widget widget, int newZoom, float scalingFactor) {
        if (!(widget instanceof StyledText)) {
            return;
        }
        StyledText styledText = (StyledText)widget;
        StyledText.updateAndRefreshCarets(styledText, caretToRefresh -> {
            DPIZoomChangeRegistry.applyChange(caretToRefresh, newZoom, scalingFactor);
            Caret.win32_setHeight(caretToRefresh, styledText.getLineHeight());
        });
    }

    private static void handleCComboDPIChange(Widget widget, int newZoom, float scalingFactor) {
        if (!(widget instanceof CCombo)) {
            return;
        }
        CCombo combo = (CCombo)widget;
        CCombo.updateAndRefreshChildren(combo, childWidget -> DPIZoomChangeRegistry.applyChange(childWidget, newZoom, scalingFactor));
    }
}

