/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbProperties;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnGetProperties;
import org.tmatesoft.svn.core.wc2.SvnInheritedProperties;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgGetProperties
extends SvnNgOperationRunner<SVNProperties, SvnGetProperties> {
    @Override
    protected SVNProperties run(SVNWCContext context) throws SVNException {
        for (SvnTarget target : ((SvnGetProperties)this.getOperation()).getTargets()) {
            if (!target.isFile()) continue;
            this.run(context, target.getFile());
        }
        return (SVNProperties)((SvnGetProperties)this.getOperation()).first();
    }

    protected SVNProperties run(SVNWCContext context, File target) throws SVNException {
        boolean pristine = ((SvnGetProperties)this.getOperation()).getRevision() == SVNRevision.COMMITTED || ((SvnGetProperties)this.getOperation()).getRevision() == SVNRevision.BASE;
        SVNNodeKind kind = context.getDb().readKind(target, true, pristine, false);
        if (kind == SVNNodeKind.UNKNOWN || kind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", (Object)target);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (((SvnGetProperties)this.getOperation()).getTargetInheritedPropertiesReceiver() != null) {
            boolean hasLocalIProps;
            SVNRevision pegRevision = ((SvnGetProperties)this.getOperation()).getFirstTarget().getResolvedPegRevision(SVNRevision.HEAD, SVNRevision.WORKING);
            SVNRevision revision = ((SvnGetProperties)this.getOperation()).getRevision() == SVNRevision.UNDEFINED ? pegRevision : ((SvnGetProperties)this.getOperation()).getRevision();
            boolean bl = hasLocalIProps = !(pegRevision != SVNRevision.WORKING && pegRevision != SVNRevision.UNDEFINED || revision != SVNRevision.WORKING && revision != SVNRevision.UNDEFINED);
            if (hasLocalIProps) {
                this.getLocaliProps(context, target);
            } else {
                Structure<StructureFields.NodeOriginInfo> origin = context.getNodeOrigin(target, false, StructureFields.NodeOriginInfo.isCopy, StructureFields.NodeOriginInfo.copyRootAbsPath, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl, StructureFields.NodeOriginInfo.reposUuid, StructureFields.NodeOriginInfo.revision);
                File reposRelPath = (File)origin.get(StructureFields.NodeOriginInfo.reposRelpath);
                if (reposRelPath != null) {
                    SVNURL rootURL = (SVNURL)origin.get(StructureFields.NodeOriginInfo.reposRootUrl);
                    SVNURL url = rootURL.appendPath(SVNFileUtil.getFilePath(reposRelPath), false);
                    Structure<SvnRepositoryAccess.RevisionsPair> revisionPair = null;
                    if (pegRevision.isLocal()) {
                        revisionPair = this.getRepositoryAccess().getRevisionNumber(null, ((SvnGetProperties)this.getOperation()).getFirstTarget(), pegRevision, revisionPair);
                        long pegrevnum = revisionPair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
                        pegRevision = SVNRevision.create(pegrevnum);
                    }
                    if (revision.isLocal()) {
                        revisionPair = this.getRepositoryAccess().getRevisionNumber(null, ((SvnGetProperties)this.getOperation()).getFirstTarget(), revision, revisionPair);
                        long revnum = revisionPair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
                        revision = SVNRevision.create(revnum);
                    }
                    SvnTarget opTarget = ((SvnGetProperties)this.getOperation()).getFirstTarget();
                    Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(SvnTarget.fromURL(url), revision, pegRevision, null);
                    SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
                    long revnum = repositoryInfo.lng(SvnRepositoryAccess.RepositoryInfo.revision);
                    repositoryInfo.release();
                    SVNURL repositoryRoot = repository.getRepositoryRoot(true);
                    Map<String, SVNProperties> inheritedProperties = repository.getInheritedProperties("", revnum, null);
                    ArrayList<SvnInheritedProperties> result = new ArrayList<SvnInheritedProperties>();
                    for (String path : inheritedProperties.keySet()) {
                        SvnInheritedProperties propItem = new SvnInheritedProperties();
                        propItem.setTarget(SvnTarget.fromURL(repositoryRoot.appendPath(path, false)));
                        propItem.setProperties(inheritedProperties.get(path));
                        result.add(propItem);
                    }
                    if (!result.isEmpty()) {
                        ((SvnGetProperties)this.getOperation()).getTargetInheritedPropertiesReceiver().receive(opTarget, result);
                    }
                }
            }
        }
        if (kind == SVNNodeKind.DIR) {
            if (((SvnGetProperties)this.getOperation()).getDepth() == SVNDepth.EMPTY) {
                if (!this.matchesChangelist(target)) {
                    return (SVNProperties)((SvnGetProperties)this.getOperation()).first();
                }
                properties = null;
                properties = pristine ? context.getDb().readPristineProperties(target) : context.getDb().readProperties(target);
                if (properties != null && !properties.isEmpty()) {
                    ((SvnGetProperties)this.getOperation()).receive(SvnTarget.fromFile(target), properties);
                }
            } else {
                SVNWCDb db = (SVNWCDb)context.getDb();
                db.readPropertiesRecursively(target, ((SvnGetProperties)this.getOperation()).getDepth(), false, pristine, ((SvnGetProperties)this.getOperation()).getApplicableChangelists(), (ISvnObjectReceiver)this.getOperation());
            }
        } else {
            properties = null;
            if (pristine) {
                properties = context.getDb().readPristineProperties(target);
            } else if (!context.isNodeStatusDeleted(target)) {
                properties = context.getDb().readProperties(target);
            }
            if (properties != null && !properties.isEmpty()) {
                ((SvnGetProperties)this.getOperation()).receive(SvnTarget.fromFile(target), properties);
            }
        }
        return (SVNProperties)((SvnGetProperties)this.getOperation()).first();
    }

    private void getLocaliProps(SVNWCContext context, File target) throws SVNException {
        SVNWCDb.DirParsedInfo pdh = ((SVNWCDb)context.getDb()).parseDir(target, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbRoot wcRoot = pdh.wcDbDir.getWCRoot();
        List<Structure<StructureFields.InheritedProperties>> inheritedProps = SvnWcDbProperties.readInheritedProperties(wcRoot, pdh.localRelPath, null);
        ArrayList<SvnInheritedProperties> resultList = new ArrayList<SvnInheritedProperties>();
        SVNURL repositoryRoot = null;
        if (inheritedProps != null && !inheritedProps.isEmpty()) {
            for (Structure<StructureFields.InheritedProperties> props : inheritedProps) {
                SvnInheritedProperties result = new SvnInheritedProperties();
                result.setProperties((SVNProperties)props.get(StructureFields.InheritedProperties.properties));
                String pathOrURL = (String)props.get(StructureFields.InheritedProperties.pathOrURL);
                if (SVNPathUtil.isURL(pathOrURL)) {
                    result.setTarget(SvnTarget.fromURL(SVNURL.parseURIEncoded(pathOrURL)));
                } else if (SVNPathUtil.isAbsolute(pathOrURL)) {
                    File absolutePath = SVNFileUtil.createFilePath(pathOrURL);
                    result.setTarget(SvnTarget.fromFile(absolutePath));
                } else {
                    if (repositoryRoot == null) {
                        Structure<StructureFields.NodeInfo> info = context.getDb().readInfo(target, StructureFields.NodeInfo.reposRootUrl);
                        repositoryRoot = (SVNURL)info.get(StructureFields.NodeInfo.reposRootUrl);
                    }
                    if (repositoryRoot == null) {
                        ISVNWCDb.WCDbAdditionInfo additionInfo = context.getDb().scanAddition(target, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.reposRootUrl);
                        repositoryRoot = additionInfo.reposRootUrl;
                    }
                    result.setTarget(SvnTarget.fromURL(repositoryRoot.appendPath(pathOrURL, false)));
                }
                resultList.add(result);
            }
            ((SvnGetProperties)this.getOperation()).getTargetInheritedPropertiesReceiver().receive(((SvnGetProperties)this.getOperation()).getFirstTarget(), resultList);
        }
    }

    @Override
    public boolean isApplicable(SvnGetProperties operation, SvnWcGeneration wcGeneration) throws SVNException {
        return !operation.isRevisionProperties() && super.isApplicable(operation, wcGeneration);
    }
}

