/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNURLUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbReader;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.core.wc2.ISvnCommitParameters;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgCommitUtil {
    public static SvnCommitPacket harvestCopyCommitables(SVNWCContext context, File path, SVNURL dst, SvnCommitPacket packet, ISvnUrlKindCallback urlKindCallback, ISvnCommitParameters commitParameters, Map<File, String> externalsStorage) throws SVNException {
        SVNWCContext.SVNWCNodeReposInfo reposInfo = context.getNodeReposInfo(path);
        File commitRelPath = new File(SVNURLUtil.getRelativeURL(reposInfo.reposRootUrl, dst, false));
        SvnNgCommitUtil.harvestCommittables(context, path, packet, null, reposInfo.reposRootUrl, commitRelPath, true, SVNDepth.INFINITY, false, null, null, false, false, urlKindCallback, commitParameters, externalsStorage, context.getEventHandler());
        return packet;
    }

    public static SvnCommitPacket harvestCommittables(SVNWCContext context, SvnCommitPacket packet, Map<SVNURL, String> lockTokens, File baseDirPath, Collection<String> targets, int depthEmptyStart, SVNDepth depth, boolean justLocked, Collection<String> changelists, ISvnUrlKindCallback urlKindCallback, ISvnCommitParameters commitParameters, Map<File, String> externalsStorage) throws SVNException {
        HashMap<File, File> danglers = new HashMap<File, File>();
        int i = -1;
        for (String target : targets) {
            SVNURL repositoryRootUrl;
            ++i;
            File targetPath = SVNFileUtil.createFilePath(baseDirPath, target);
            SVNNodeKind kind = context.readKind(targetPath, true, true);
            if (kind == SVNNodeKind.NONE) {
                try {
                    Structure<StructureFields.NodeInfo> structure = context.getDb().readInfo(targetPath, StructureFields.NodeInfo.status);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not under version control", (Object)targetPath);
                        SVNErrorManager.error(errorMessage, SVNLogType.WC);
                    }
                    throw e;
                }
                SVNTreeConflictDescription tc = context.getTreeConflict(targetPath);
                if (tc != null) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", (Object)targetPath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                } else {
                    err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not under version control", (Object)targetPath);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
            }
            try {
                SVNWCContext.SVNWCNodeReposInfo reposInfo = context.getNodeReposInfo(targetPath);
                repositoryRootUrl = reposInfo.reposRootUrl;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                    throw e;
                }
                repositoryRootUrl = null;
            }
            boolean added = context.isNodeAdded(targetPath);
            if (added) {
                File parentPath = SVNFileUtil.getParentFile(targetPath);
                try {
                    boolean parentIsAdded = context.isNodeAdded(parentPath);
                    if (parentIsAdded) {
                        Structure<StructureFields.NodeOriginInfo> origin = context.getNodeOrigin(parentPath, false, StructureFields.NodeOriginInfo.copyRootAbsPath, StructureFields.NodeOriginInfo.isCopy);
                        if (origin.is(StructureFields.NodeOriginInfo.isCopy)) {
                            parentPath = (File)origin.get(StructureFields.NodeOriginInfo.copyRootAbsPath);
                        }
                        origin.release();
                        danglers.put(parentPath, targetPath);
                    }
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT, "''{0}'' is scheduled for addition within unversioned parent", (Object)targetPath);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    throw e;
                }
            }
            SvnNgCommitUtil.bailOnTreeConflictedAncestor(context, targetPath);
            if (i == depthEmptyStart) {
                depth = SVNDepth.EMPTY;
            }
            SvnNgCommitUtil.harvestCommittables(context, targetPath, packet, lockTokens, repositoryRootUrl, null, false, depth, justLocked, changelists, danglers, false, false, urlKindCallback, commitParameters, externalsStorage, context.getEventHandler());
        }
        for (SVNURL root : packet.getRepositoryRoots()) {
            SvnNgCommitUtil.handleDescendants(context, packet, root, new ArrayList<SvnCommitItem>(packet.getItems(root)), urlKindCallback, context.getEventHandler());
        }
        for (File danglingParent : danglers.keySet()) {
            if (packet.hasItem(danglingParent)) continue;
            File danglingChild = (File)danglers.get(danglingParent);
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not known to exist in the repository and is not part of the commit, yet its child ''{1}'' is part of the commit", danglingParent.getAbsolutePath(), danglingChild.getAbsolutePath());
            ISVNEventHandler eventHandler = context.getEventHandler();
            if (eventHandler != null) {
                SVNEvent event = SVNEventFactory.createSVNEvent(danglingChild, SVNNodeKind.UNKNOWN, null, -1L, SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN, SVNStatusType.LOCK_UNKNOWN, SVNEventAction.FAILED_NO_PARENT, SVNEventAction.FAILED_NO_PARENT, err, null);
                eventHandler.handleEvent(event, -1.0);
            }
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return packet;
    }

    private static void handleDescendants(SVNWCContext context, SvnCommitPacket packet, SVNURL rootUrl, Collection<SvnCommitItem> items, ISvnUrlKindCallback urlKindCallback, ISVNEventHandler eventHandler) throws SVNException {
        for (SvnCommitItem item : items) {
            if (!item.hasFlag(1) || item.getCopyFromUrl() == null) continue;
            if (eventHandler != null) {
                eventHandler.checkCancelled();
            }
            Collection<File> notPresent = SvnWcDbReader.getNotPresentDescendants((SVNWCDb)context.getDb(), item.getPath());
            for (File absent : notPresent) {
                boolean itemFound = false;
                File localAbsPath = SVNFileUtil.createFilePath(item.getPath(), absent);
                for (SvnCommitItem i : items) {
                    if (!i.getPath().equals(localAbsPath)) continue;
                    itemFound = true;
                    break;
                }
                if (itemFound) continue;
                SVNURL url = SVNWCUtils.join(item.getCopyFromUrl(), absent);
                SVNNodeKind kind = SVNNodeKind.UNKNOWN;
                if (urlKindCallback != null && (kind = urlKindCallback.getUrlKind(url, item.getCopyFromRevision())) == SVNNodeKind.NONE) continue;
                packet.addItem(localAbsPath, rootUrl, kind, SVNWCUtils.join(item.getUrl(), absent), -1L, null, -1L, 2);
            }
        }
    }

    public static void harvestCommittables(SVNWCContext context, File localAbsPath, SvnCommitPacket committables, Map<SVNURL, String> lockTokens, SVNURL repositoryRootUrl, File copyModeRelPath, boolean copyModeRoot, SVNDepth depth, boolean justLocked, Collection<String> changelists, Map<File, File> danglers, boolean skipFiles, boolean skipDirs, ISvnUrlKindCallback urlKindCallback, ISvnCommitParameters commitParameters, Map<File, String> externalsStorage, ISVNEventHandler eventHandler) throws SVNException {
        CommitStatusWalker commitStatusWalker = new CommitStatusWalker();
        commitStatusWalker.rootAbsPath = localAbsPath;
        commitStatusWalker.committables = committables;
        commitStatusWalker.lockTokens = lockTokens;
        commitStatusWalker.commitRelPath = copyModeRelPath;
        commitStatusWalker.depth = depth;
        commitStatusWalker.justLocked = justLocked;
        commitStatusWalker.changeLists = changelists;
        commitStatusWalker.danglers = danglers;
        commitStatusWalker.checkUrlCallback = urlKindCallback;
        commitStatusWalker.context = context;
        commitStatusWalker.eventHandler = eventHandler;
        commitStatusWalker.externalsStorage = externalsStorage;
        SVNStatusEditor17 editor = new SVNStatusEditor17(localAbsPath, context, context.getOptions(), false, copyModeRelPath != null, depth, commitStatusWalker);
        editor.walkStatus(localAbsPath, depth, copyModeRelPath != null, false, false, null);
    }

    private static void harvestNotPresentForCopy(SVNWCContext context, File localAbsPath, SvnCommitPacket committables, SVNURL reposRootUrl, File commitRelPath, ISvnUrlKindCallback urlKindCallback) throws SVNException {
        List<File> children = context.getChildrenOfWorkingNode(localAbsPath, true);
        for (File thisAbsPath : children) {
            SVNNodeKind kind;
            String name = SVNFileUtil.getFileName(thisAbsPath);
            SVNWCContext.NodePresence nodePresence = context.getNodePresence(thisAbsPath, false);
            if (!nodePresence.isNotPresent) continue;
            File thisCommitRelPath = commitRelPath == null ? null : SVNFileUtil.createFilePath(commitRelPath, name);
            if (urlKindCallback != null) {
                Structure<StructureFields.NodeOriginInfo> nodeOrigin = context.getNodeOrigin(SVNFileUtil.getParentFile(thisAbsPath), false, StructureFields.NodeOriginInfo.revision, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl);
                long parentRev = nodeOrigin.lng(StructureFields.NodeOriginInfo.revision);
                File parentReposRelPath = (File)nodeOrigin.get(StructureFields.NodeOriginInfo.reposRelpath);
                SVNURL parentReposRootUrl = (SVNURL)nodeOrigin.get(StructureFields.NodeOriginInfo.reposRootUrl);
                SVNURL nodeUrl = parentReposRootUrl.appendPath(SVNFileUtil.getFilePath(parentReposRelPath), false).appendPath(SVNFileUtil.getFileName(thisAbsPath), false);
                kind = urlKindCallback.getUrlKind(nodeUrl, parentRev);
                if (kind == SVNNodeKind.NONE) {
                    continue;
                }
            } else {
                kind = context.readKind(thisAbsPath, true);
            }
            committables.addItem(thisAbsPath, kind, reposRootUrl, SVNFileUtil.getFilePath(thisCommitRelPath), -1L, null, -1L, null, 2);
        }
    }

    private static Structure<NodeCommitStatus> getNodeCommitStatus(SVNWCContext context, File localAbsPath) throws SVNException {
        Object result = Structure.obtain(NodeCommitStatus.class);
        Structure<StructureFields.NodeInfo> nodeInfo = context.getDb().readInfo(localAbsPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.revision, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.originalRevision, StructureFields.NodeInfo.originalReposRelpath, StructureFields.NodeInfo.lock, StructureFields.NodeInfo.changelist, StructureFields.NodeInfo.conflicted, StructureFields.NodeInfo.opRoot, StructureFields.NodeInfo.hadProps, StructureFields.NodeInfo.propsMod, StructureFields.NodeInfo.haveBase, StructureFields.NodeInfo.haveMoreWork);
        if (nodeInfo.get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.File) {
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.kind, SVNNodeKind.FILE);
        } else if (nodeInfo.get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.Dir) {
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.kind, SVNNodeKind.DIR);
        } else {
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.kind, SVNNodeKind.UNKNOWN);
        }
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.reposRelPath, nodeInfo.get(StructureFields.NodeInfo.reposRelPath));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.revision, nodeInfo.lng(StructureFields.NodeInfo.revision));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.originalReposRelPath, nodeInfo.get(StructureFields.NodeInfo.originalReposRelpath));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.originalRevision, nodeInfo.lng(StructureFields.NodeInfo.originalRevision));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.changelist, nodeInfo.get(StructureFields.NodeInfo.changelist));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.propsMod, nodeInfo.is(StructureFields.NodeInfo.propsMod));
        ISVNWCDb.SVNWCDbStatus nodeStatus = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfo.get(StructureFields.NodeInfo.status));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.added, nodeStatus == ISVNWCDb.SVNWCDbStatus.Added);
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.deleted, nodeStatus == ISVNWCDb.SVNWCDbStatus.Deleted);
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.notPresent, nodeStatus == ISVNWCDb.SVNWCDbStatus.NotPresent);
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.excluded, nodeStatus == ISVNWCDb.SVNWCDbStatus.Excluded);
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.isOpRoot, nodeInfo.is(StructureFields.NodeInfo.opRoot));
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.conflicted, nodeInfo.is(StructureFields.NodeInfo.conflicted));
        if (nodeStatus == ISVNWCDb.SVNWCDbStatus.Added && nodeInfo.is(StructureFields.NodeInfo.opRoot) && (nodeInfo.is(StructureFields.NodeInfo.haveBase) || nodeInfo.is(StructureFields.NodeInfo.haveMoreWork))) {
            Structure<SvnWcDbReader.ReplaceInfo> replaceInfo = SvnWcDbReader.readNodeReplaceInfo((SVNWCDb)context.getDb(), localAbsPath, SvnWcDbReader.ReplaceInfo.replaceRoot);
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.isReplaceRoot, replaceInfo.is(SvnWcDbReader.ReplaceInfo.replaceRoot));
            replaceInfo.release();
        } else {
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.isReplaceRoot, false);
        }
        if (nodeInfo.get(StructureFields.NodeInfo.kind) == ISVNWCDb.SVNWCDbKind.File && (nodeInfo.is(StructureFields.NodeInfo.hadProps) || nodeInfo.is(StructureFields.NodeInfo.propsMod))) {
            SVNProperties properties = context.getDb().readProperties(localAbsPath);
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.symlink, properties.getStringValue("svn:special") != null);
        } else {
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.symlink, false);
        }
        if (nodeInfo.is(StructureFields.NodeInfo.haveBase) && (nodeInfo.lng(StructureFields.NodeInfo.revision) < 0L || nodeStatus == ISVNWCDb.SVNWCDbStatus.Normal)) {
            ISVNWCDb.WCDbBaseInfo baseInfo = context.getDb().getBaseInfo(localAbsPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.updateRoot);
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.revision, baseInfo.revision);
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.updateRoot, baseInfo.updateRoot);
        } else {
            ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.updateRoot, false);
        }
        ISVNWCDb.SVNWCDbLock lock = (ISVNWCDb.SVNWCDbLock)nodeInfo.get(StructureFields.NodeInfo.lock);
        ((Structure)result).set((NodeCommitStatus)NodeCommitStatus.lockToken, lock != null ? lock.token : null);
        nodeInfo.release();
        return result;
    }

    private static void bailOnTreeConflictedChildren(SVNWCContext context, File localAbsPath, SVNNodeKind kind, SVNDepth depth, Collection<String> changelistsSet) throws SVNException {
        if (depth == SVNDepth.EMPTY || kind != SVNNodeKind.DIR) {
            return;
        }
        Map<String, SVNTreeConflictDescription> conflicts = context.getDb().opReadAllTreeConflicts(localAbsPath);
        if (conflicts == null || conflicts.isEmpty()) {
            return;
        }
        for (SVNTreeConflictDescription conflict : conflicts.values()) {
            if (conflict.getNodeKind() == SVNNodeKind.DIR && depth == SVNDepth.FILES || !context.isChangelistMatch(localAbsPath, changelistsSet)) continue;
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", (Object)conflict.getPath());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    private static void collectLocks(final SVNWCContext context, File path, final Map<SVNURL, String> lockTokens) throws SVNException {
        SVNWCContext.ISVNWCNodeHandler nodeHandler = new SVNWCContext.ISVNWCNodeHandler(){

            @Override
            public void nodeFound(File localAbspath, ISVNWCDb.SVNWCDbKind kind) throws SVNException {
                ISVNWCDb.SVNWCDbLock nodeLock = context.getNodeLock(localAbspath);
                if (nodeLock == null || nodeLock.token == null) {
                    return;
                }
                SVNURL url = context.getNodeUrl(localAbspath);
                if (url != null) {
                    lockTokens.put(url, nodeLock.token);
                }
            }
        };
        context.nodeWalkChildren(path, nodeHandler, false, SVNDepth.INFINITY, null);
    }

    private static void bailOnTreeConflictedAncestor(SVNWCContext context, File firstAbspath) throws SVNException {
        SVNWCDb.DirParsedInfo pdh = ((SVNWCDb)context.getDb()).parseDir(firstAbspath, SVNSqlJetDb.Mode.ReadOnly);
        SVNWCDbRoot wcRoot = pdh.wcDbDir.getWCRoot();
        File localAbsPath = SVNFileUtil.getFileDir(firstAbspath);
        while (SVNPathUtil.isAncestor(SVNFileUtil.getFilePath(wcRoot.getAbsPath()), SVNFileUtil.getFilePath(localAbsPath))) {
            boolean treeConflicted = context.getConflicted((File)localAbsPath, (boolean)false, (boolean)false, (boolean)true).treeConflicted;
            if (treeConflicted) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in tree-conflict", (Object)localAbsPath);
                ISVNEventHandler eventHandler = context.getEventHandler();
                if (eventHandler != null) {
                    SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.UNKNOWN, null, -1L, SVNStatusType.UNKNOWN, SVNStatusType.UNKNOWN, SVNStatusType.LOCK_UNKNOWN, SVNEventAction.FAILED_CONFLICT, SVNEventAction.FAILED_CONFLICT, err, null);
                    eventHandler.handleEvent(event, -1.0);
                }
                SVNErrorManager.error(err, SVNLogType.WC);
                return;
            }
            if (localAbsPath.getParentFile() == null || localAbsPath.getParentFile().equals(localAbsPath)) break;
            localAbsPath = SVNFileUtil.getFileDir(localAbsPath);
        }
    }

    public static SVNURL translateCommitables(Collection<SvnCommitItem> items, Map<String, SvnCommitItem> decodedPaths) throws SVNException {
        HashMap<SVNURL, SvnCommitItem> itemsMap = new HashMap<SVNURL, SvnCommitItem>();
        for (SvnCommitItem item : items) {
            if (itemsMap.containsKey(item.getUrl())) {
                SvnCommitItem oldItem = (SvnCommitItem)itemsMap.get(item.getUrl());
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_DUPLICATE_COMMIT_URL, "Cannot commit both ''{0}'' and ''{1}'' as they refer to the same URL", item.getPath(), oldItem.getPath());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            itemsMap.put(item.getUrl(), item);
        }
        Iterator urls = itemsMap.keySet().iterator();
        SVNURL baseURL = (SVNURL)urls.next();
        while (urls.hasNext()) {
            SVNURL url = (SVNURL)urls.next();
            baseURL = SVNURLUtil.getCommonURLAncestor(baseURL, url);
        }
        if (itemsMap.containsKey(baseURL)) {
            SvnCommitItem rootItem = (SvnCommitItem)itemsMap.get(baseURL);
            if (rootItem.getKind() != SVNNodeKind.DIR) {
                baseURL = baseURL.removePathTail();
            } else if (rootItem.getKind() == SVNNodeKind.DIR && (rootItem.hasFlag(1) || rootItem.hasFlag(2) || rootItem.hasFlag(16) || rootItem.hasFlag(32))) {
                baseURL = baseURL.removePathTail();
            }
        }
        if (baseURL == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Cannot compute base URL for commit operation");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        for (SVNURL url : itemsMap.keySet()) {
            SvnCommitItem item = (SvnCommitItem)itemsMap.get(url);
            String realPath = url.equals(baseURL) ? "" : SVNPathUtil.getRelativePath(baseURL.getPath(), url.getPath());
            decodedPaths.put(realPath, item);
        }
        return baseURL;
    }

    public static Map<String, String> translateLockTokens(Map<SVNURL, String> lockTokens, SVNURL baseURL) {
        TreeMap<String, String> translatedLocks = new TreeMap<String, String>();
        for (SVNURL url : lockTokens.keySet()) {
            if (!SVNURLUtil.isAncestor(baseURL, url)) continue;
            String token = lockTokens.get(url);
            String path = url.getPath().substring(baseURL.getPath().length());
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            translatedLocks.put(path, token);
        }
        return translatedLocks;
    }

    static interface ISvnUrlKindCallback {
        public SVNNodeKind getUrlKind(SVNURL var1, long var2) throws SVNException;
    }

    private static class CommitStatusWalker
    implements ISvnObjectReceiver<SvnStatus> {
        public File rootAbsPath;
        public File commitRelPath;
        public SVNDepth depth;
        public boolean justLocked;
        public Collection<String> changeLists;
        public Map<File, File> danglers;
        public ISvnUrlKindCallback checkUrlCallback;
        public ISVNEventHandler eventHandler;
        public SVNWCContext context;
        public File skipBelowAbsPath;
        public Map<SVNURL, String> lockTokens;
        public Map<File, String> externalsStorage;
        public SvnCommitPacket committables;

        private CommitStatusWalker() {
        }

        @Override
        public void receive(SvnTarget target, SvnStatus status) throws SVNException {
            String externalsProperty;
            SVNProperties properties;
            boolean matchesChangeLists;
            boolean copyMode;
            File localAbsPath = target.getFile();
            int stateFlags = 0;
            boolean isHarvestRoot = this.rootAbsPath.equals(localAbsPath);
            boolean copyModeRoot = this.commitRelPath != null && isHarvestRoot;
            File movedFromAbsPath = null;
            File commitRelPath = null;
            if (this.commitRelPath != null) {
                commitRelPath = SVNFileUtil.createFilePath(this.commitRelPath, SVNFileUtil.skipAncestor(this.rootAbsPath, localAbsPath));
            }
            boolean bl = copyMode = commitRelPath != null;
            if (this.skipBelowAbsPath != null && SVNPathUtil.isAncestor(SVNFileUtil.getFilePath(this.skipBelowAbsPath), SVNFileUtil.getFilePath(localAbsPath))) {
                return;
            }
            this.skipBelowAbsPath = null;
            if (SVNStatusType.STATUS_UNVERSIONED.equals(status.getNodeStatus()) || SVNStatusType.STATUS_IGNORED.equals(status.getNodeStatus()) || SVNStatusType.STATUS_EXTERNAL.equals(status.getNodeStatus()) || SVNStatusType.STATUS_NONE.equals(status.getNodeStatus())) {
                if (isHarvestRoot) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "''{0}'' is not under version control", (Object)localAbsPath);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                return;
            }
            if (!(!SVNStatusType.STATUS_NORMAL.equals(status.getNodeStatus()) || copyMode || status.isConflicted() || this.justLocked && status.getLock() != null)) {
                return;
            }
            if (this.committables.hasItem(localAbsPath)) {
                return;
            }
            assert (copyMode && commitRelPath != null || !copyMode && commitRelPath == null);
            assert (copyModeRoot && copyMode || !copyModeRoot);
            boolean bl2 = matchesChangeLists = this.changeLists == null || status.getChangelist() != null && this.changeLists.contains(status.getChangelist());
            if (status.getKind() != SVNNodeKind.DIR && !matchesChangeLists) {
                return;
            }
            if (status.isConflicted() && matchesChangeLists) {
                if (this.eventHandler != null) {
                    this.eventHandler.handleEvent(SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.FAILED_CONFLICT, SVNEventAction.FAILED_CONFLICT, null, null), -1.0);
                }
                errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "Aborting commit: ''{0}'' remains in conflict", (Object)localAbsPath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            } else if (status.getNodeStatus() == SVNStatusType.STATUS_OBSTRUCTED) {
                if (this.eventHandler != null) {
                    this.eventHandler.handleEvent(SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.FAILED_OBSTRUCTION, SVNEventAction.FAILED_OBSTRUCTION, null, null), -1.0);
                }
                errorMessage = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "Node ''{0}'' has unexpectedly changed kind", (Object)localAbsPath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            if (this.externalsStorage != null && matchesChangeLists && (properties = this.context.getActualProps(localAbsPath)) != null && (externalsProperty = properties.getStringValue("svn:externals")) != null) {
                this.externalsStorage.put(localAbsPath, externalsProperty);
            }
            if (status.isFileExternal() && !isHarvestRoot) {
                return;
            }
            Structure<NodeCommitStatus> nodeCommitStatus = SvnNgCommitUtil.getNodeCommitStatus(this.context, localAbsPath);
            boolean isAdded = nodeCommitStatus.is(NodeCommitStatus.added);
            boolean isDeleted = nodeCommitStatus.is(NodeCommitStatus.deleted);
            boolean isReplaced = nodeCommitStatus.is(NodeCommitStatus.isReplaceRoot);
            boolean isOpRoot = nodeCommitStatus.is(NodeCommitStatus.isOpRoot);
            long nodeRev = nodeCommitStatus.lng(NodeCommitStatus.revision);
            long originalRev = nodeCommitStatus.lng(NodeCommitStatus.originalRevision);
            File originalRelPath = (File)nodeCommitStatus.get(NodeCommitStatus.originalReposRelPath);
            if (status.getNodeStatus() == SVNStatusType.STATUS_MISSING && matchesChangeLists) {
                if (isAdded && isOpRoot) {
                    if (this.eventHandler != null) {
                        this.eventHandler.handleEvent(SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.FAILED_MISSING, SVNEventAction.FAILED_MISSING, null, null), -1.0);
                    }
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_NOT_FOUND, "''{0}'' is scheduled for addition, but is missing", (Object)localAbsPath);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                return;
            }
            if (isDeleted && !isOpRoot) {
                return;
            }
            if (isDeleted || isReplaced) {
                stateFlags |= 2;
            }
            File cfRelPath = null;
            long cfRev = -1L;
            if (isAdded && isOpRoot) {
                stateFlags |= 1;
                if (originalRelPath != null) {
                    stateFlags |= 0x10;
                    cfRelPath = originalRelPath;
                    cfRev = originalRev;
                    if (status.getMovedFromPath() != null && !copyMode) {
                        stateFlags |= 0x40;
                        movedFromAbsPath = status.getMovedFromPath();
                    }
                }
            } else if (copyMode && (stateFlags & 2) == 0) {
                long dirRev = -1L;
                if (!(copyModeRoot || status.isSwitched() || isAdded)) {
                    ISVNWCDb.WCDbBaseInfo nodeBase = this.context.getNodeBase(SVNFileUtil.getFileDir(localAbsPath), false, false);
                    dirRev = nodeBase.revision;
                }
                if (copyModeRoot || status.isSwitched() || nodeRev != dirRev) {
                    stateFlags |= 1;
                    stateFlags |= 0x10;
                    if (status.isCopied()) {
                        cfRev = originalRev;
                        cfRelPath = originalRelPath;
                    } else {
                        cfRev = status.getRevision();
                        cfRelPath = SVNFileUtil.createFilePath(status.getRepositoryRelativePath());
                    }
                }
            }
            if ((stateFlags & 2) == 0 || (stateFlags & 1) != 0) {
                boolean textMod = false;
                boolean propMod = false;
                if (status.getKind() == SVNNodeKind.FILE) {
                    textMod = (stateFlags & 1) != 0 && (stateFlags & 0x10) == 0 ? true : status.getTextStatus() != SVNStatusType.STATUS_NORMAL;
                }
                boolean bl3 = propMod = status.getPropertiesStatus() != SVNStatusType.STATUS_NORMAL && status.getPropertiesStatus() != SVNStatusType.STATUS_NONE;
                if (textMod) {
                    stateFlags |= 4;
                }
                if (propMod) {
                    stateFlags |= 8;
                }
            }
            if (status.getLock() != null && this.lockTokens != null && (stateFlags != 0 || this.justLocked)) {
                stateFlags |= 0x20;
            }
            if (matchesChangeLists && stateFlags != 0) {
                File reposRelPath = copyMode ? commitRelPath : SVNFileUtil.createFilePath(status.getRepositoryRelativePath());
                long revision = copyMode ? -1L : nodeRev;
                Map<SVNURL, String> lockTokens = this.lockTokens;
                SVNLock lock = status.getLock();
                assert (status.getRepositoryRootUrl() != null && reposRelPath != null);
                SvnCommitItem item = this.committables.addItem(localAbsPath, status.getKind(), status.getRepositoryRootUrl(), SVNFileUtil.getFilePath(reposRelPath), revision, SVNFileUtil.getFilePath(cfRelPath), cfRev, movedFromAbsPath, stateFlags);
                if (lockTokens != null && lock != null && (stateFlags & 0x20) != 0) {
                    lockTokens.put(item.getUrl(), lock.getID());
                }
            }
            if (matchesChangeLists && (stateFlags & 2) != 0 && !copyMode && SVNRevision.isValidRevisionNumber(nodeRev) && this.lockTokens != null) {
                Map<SVNURL, String> localRelPathTokens = this.context.getDb().getNodeLockTokensRecursive(localAbsPath);
                for (Map.Entry<SVNURL, String> entry : localRelPathTokens.entrySet()) {
                    SVNURL key = entry.getKey();
                    String value = entry.getValue();
                    if (value == null) continue;
                    this.lockTokens.put(key, value);
                }
            }
            if (matchesChangeLists && (isHarvestRoot || this.changeLists != null) && stateFlags != 0 && (isAdded || isDeleted && isOpRoot && status.isCopied()) && this.danglers != null) {
                Map<File, File> danglers = this.danglers;
                File parentAbsPath = SVNFileUtil.getParentFile(localAbsPath);
                boolean parentAdded = this.committables.hasItem(parentAbsPath) ? false : this.context.isNodeAdded(parentAbsPath);
                if (parentAdded) {
                    Structure<StructureFields.NodeOriginInfo> nodeOrigin = this.context.getNodeOrigin(parentAbsPath, false, StructureFields.NodeOriginInfo.isCopy, StructureFields.NodeOriginInfo.copyRootAbsPath);
                    boolean parentIsCopy = nodeOrigin.is(StructureFields.NodeOriginInfo.isCopy);
                    File copyRootAbsPath = (File)nodeOrigin.get(StructureFields.NodeOriginInfo.copyRootAbsPath);
                    if (parentIsCopy) {
                        parentAbsPath = copyRootAbsPath;
                    }
                    if (!danglers.containsKey(parentAbsPath)) {
                        danglers.put(parentAbsPath, localAbsPath);
                    }
                }
            }
            if (isDeleted && !isAdded) {
                if (status.getKind() == SVNNodeKind.DIR) {
                    this.skipBelowAbsPath = localAbsPath;
                }
                return;
            }
            if (copyMode && !isAdded && !isDeleted && status.getKind() == SVNNodeKind.DIR) {
                SvnNgCommitUtil.harvestNotPresentForCopy(this.context, localAbsPath, this.committables, status.getRepositoryRootUrl(), commitRelPath, this.checkUrlCallback);
            }
        }
    }

    private static enum NodeCommitStatus {
        kind,
        added,
        deleted,
        notPresent,
        excluded,
        isOpRoot,
        isReplaceRoot,
        symlink,
        reposRelPath,
        revision,
        originalReposRelPath,
        originalRevision,
        changelist,
        conflicted,
        updateRoot,
        lockToken,
        propsMod;

    }
}

