/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffEditor;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SvnDiffStatusReceiver
implements ISvnObjectReceiver<SvnStatus> {
    private final SVNWCContext context;
    private final File anchor;
    private final ISVNWCDb db;
    private final ISvnDiffCallback callback;
    private final boolean showCopiesAsAdds;
    private final boolean gitFormat;
    private final boolean ignoreAncestry;
    private final Collection<String> changelists;

    public SvnDiffStatusReceiver(SVNWCContext context, File anchor, ISVNWCDb db, ISvnDiffCallback callback, boolean ignoreAncestry, boolean showCopiesAsAdds, boolean gitFormat, Collection<String> changelists) {
        this.context = context;
        this.anchor = anchor;
        this.db = db;
        this.callback = callback;
        this.ignoreAncestry = ignoreAncestry;
        this.showCopiesAsAdds = showCopiesAsAdds;
        this.gitFormat = gitFormat;
        this.changelists = changelists;
    }

    public SVNWCContext getContext() {
        return this.context;
    }

    public File getAnchor() {
        return this.anchor;
    }

    public ISVNWCDb getDb() {
        return this.db;
    }

    public ISvnDiffCallback getCallback() {
        return this.callback;
    }

    public boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    public boolean isShowCopiesAsAdds() {
        return this.showCopiesAsAdds;
    }

    public boolean isGitFormat() {
        return this.gitFormat;
    }

    @Override
    public void receive(SvnTarget target, SvnStatus status) throws SVNException {
        SVNStatusType nodeStatus = status.getNodeStatus();
        if (nodeStatus == SVNStatusType.STATUS_UNVERSIONED) {
            return;
        }
        if (nodeStatus == SVNStatusType.OBSTRUCTED || nodeStatus == SVNStatusType.MISSING) {
            return;
        }
        File localAbspath = target.getFile();
        if (this.changelists != null && !this.context.matchesChangelist(localAbspath, this.changelists)) {
            return;
        }
        if (status.getKind() == SVNNodeKind.FILE) {
            if (status.getTextStatus() == SVNStatusType.STATUS_MODIFIED || status.getPropertiesStatus() == SVNStatusType.STATUS_MODIFIED || status.getNodeStatus() == SVNStatusType.STATUS_DELETED || status.getNodeStatus() == SVNStatusType.STATUS_REPLACED || (this.isShowCopiesAsAdds() || this.isGitFormat()) && status.isCopied()) {
                String path = SVNPathUtil.getRelativePath(this.getAnchor().getAbsolutePath(), localAbspath.getAbsolutePath());
                this.fileDiff(localAbspath, path);
            }
        } else if (status.getNodeStatus() == SVNStatusType.STATUS_DELETED || status.getNodeStatus() == SVNStatusType.STATUS_REPLACED || status.getPropertiesStatus() == SVNStatusType.STATUS_MODIFIED) {
            String path = SVNPathUtil.getRelativePath(this.getAnchor().getAbsolutePath(), localAbspath.getAbsolutePath());
            SVNProperties baseProps = this.getDb().readPristineProperties(localAbspath);
            if (baseProps == null) {
                baseProps = new SVNProperties();
            }
            SVNProperties actualProps = this.getDb().readProperties(localAbspath);
            SVNProperties propChanges = SvnDiffEditor.computePropDiff(baseProps, actualProps);
            this.getCallback().dirPropsChanged(null, localAbspath, false, propChanges, baseProps);
        }
    }

    private void fileDiff(File localAbspath, String path) throws SVNException {
        Structure<StructureFields.NodeInfo> nodeInfo = this.getDb().readInfo(localAbspath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.revision, StructureFields.NodeInfo.checksum, StructureFields.NodeInfo.originalReposRelpath, StructureFields.NodeInfo.opRoot, StructureFields.NodeInfo.hadProps, StructureFields.NodeInfo.propsMod, StructureFields.NodeInfo.haveBase, StructureFields.NodeInfo.haveMoreWork);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)nodeInfo.get(StructureFields.NodeInfo.status));
        ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)nodeInfo.get(StructureFields.NodeInfo.kind));
        long revision = nodeInfo.lng(StructureFields.NodeInfo.revision);
        SvnChecksum checksum = (SvnChecksum)nodeInfo.get(StructureFields.NodeInfo.checksum);
        File originalReposRelpath = (File)nodeInfo.get(StructureFields.NodeInfo.originalReposRelpath);
        Boolean opRoot = nodeInfo.is(StructureFields.NodeInfo.opRoot);
        boolean hadProps = nodeInfo.is(StructureFields.NodeInfo.hadProps);
        boolean propsMod = nodeInfo.is(StructureFields.NodeInfo.propsMod);
        boolean haveBase = nodeInfo.is(StructureFields.NodeInfo.haveBase);
        boolean haveMoreWork = nodeInfo.is(StructureFields.NodeInfo.haveMoreWork);
        boolean replaced = false;
        boolean baseReplace = false;
        SvnChecksum baseChecksum = null;
        if (status == ISVNWCDb.SVNWCDbStatus.Added && (haveBase || haveMoreWork)) {
            ISVNWCDb.SVNWCDbNodeCheckReplaceData checkReplaceData = this.getDb().nodeCheckReplace(localAbspath);
            replaced = checkReplaceData.replace;
            baseReplace = checkReplaceData.baseReplace;
            if (replaced && baseReplace) {
                ISVNWCDb.WCDbBaseInfo baseInfo = this.getDb().getBaseInfo(localAbspath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.checksum);
                ISVNWCDb.SVNWCDbStatus baseStatus = baseInfo.status;
                ISVNWCDb.SVNWCDbKind baseKind = baseInfo.kind;
                long baseRevision = baseInfo.revision;
                baseChecksum = baseInfo.checksum;
                if (baseStatus != ISVNWCDb.SVNWCDbStatus.Normal || baseKind != kind) {
                    replaced = false;
                    baseReplace = false;
                }
            } else {
                replaced = false;
                baseReplace = false;
            }
        }
        if (status == ISVNWCDb.SVNWCDbStatus.Added) {
            ISVNWCDb.WCDbAdditionInfo wcDbAdditionInfo = this.getDb().scanAddition(localAbspath, ISVNWCDb.WCDbAdditionInfo.AdditionInfoField.status);
            status = wcDbAdditionInfo.status;
        }
        if (status == ISVNWCDb.SVNWCDbStatus.Deleted || baseReplace && !this.isIgnoreAncestry()) {
            SvnChecksum delChecksum;
            SVNProperties delProps;
            if (baseReplace && !this.isIgnoreAncestry()) {
                delProps = this.getDb().getBaseProps(localAbspath);
                delChecksum = baseChecksum;
            } else {
                assert (status == ISVNWCDb.SVNWCDbStatus.Deleted);
                delProps = this.getContext().getPristineProps(localAbspath);
                delChecksum = (SvnChecksum)this.getDb().readPristineInfo(localAbspath).get(StructureFields.PristineInfo.checksum);
            }
            assert (delChecksum != null);
            File delTextAbspath = this.getDb().getPristinePath(localAbspath, delChecksum);
            if (delProps == null) {
                delProps = new SVNProperties();
            }
            String delMimeType = delProps.getStringValue("svn:mime-type");
            this.getCallback().fileDeleted(null, localAbspath, delTextAbspath, this.getEmptyFile(), delMimeType, null, delProps);
            if (status == ISVNWCDb.SVNWCDbStatus.Deleted) {
                return;
            }
        }
        File pristineAbspath = checksum != null ? this.getDb().getPristinePath(localAbspath, checksum) : (baseReplace && this.isIgnoreAncestry() ? this.getDb().getPristinePath(localAbspath, baseChecksum) : this.getEmptyFile());
        if (!baseReplace && status == ISVNWCDb.SVNWCDbStatus.Added || baseReplace && !this.isIgnoreAncestry() || (status == ISVNWCDb.SVNWCDbStatus.Copied || status == ISVNWCDb.SVNWCDbStatus.MovedHere) && (this.isShowCopiesAsAdds() || this.isGitFormat())) {
            pristineProps = new SVNProperties();
            SVNProperties actualProps = this.getContext().getActualProps(localAbspath);
            if (actualProps == null) {
                actualProps = new SVNProperties();
            }
            String actualMimeType = actualProps.getStringValue("svn:mime-type");
            SVNProperties propChanges = SvnDiffEditor.computePropDiff(pristineProps, actualProps);
            translatedFile = this.getContext().getTranslatedFile(localAbspath, localAbspath, true, false, false, false, false);
            this.getCallback().fileAdded(null, localAbspath, !this.isShowCopiesAsAdds() && this.isGitFormat() && status != ISVNWCDb.SVNWCDbStatus.Added ? pristineAbspath : this.getEmptyFile(), translatedFile, 0L, revision, null, actualMimeType, originalReposRelpath, -1L, propChanges, pristineProps);
        } else {
            translatedFile = null;
            boolean modified = this.getContext().isTextModified(localAbspath, false);
            if (modified) {
                translatedFile = this.getContext().getTranslatedFile(localAbspath, localAbspath, true, false, false, false, false);
            }
            if (baseReplace && this.isIgnoreAncestry()) {
                pristineProps = this.getDb().getBaseProps(localAbspath);
            } else {
                assert (!replaced || status == ISVNWCDb.SVNWCDbStatus.Copied || status == ISVNWCDb.SVNWCDbStatus.MovedHere);
                pristineProps = this.getDb().readPristineProperties(localAbspath);
                if (pristineProps == null) {
                    pristineProps = new SVNProperties();
                }
            }
            String pristineMimeType = pristineProps.getStringValue("svn:mime-type");
            SVNProperties actualProps = this.getDb().readProperties(localAbspath);
            String actualMimeType = actualProps.getStringValue("svn:mime-type");
            SVNProperties propChanges = SvnDiffEditor.computePropDiff(pristineProps, actualProps);
            if (modified || !propChanges.isEmpty()) {
                this.getCallback().fileChanged(null, localAbspath, modified ? pristineAbspath : null, translatedFile, revision, -1L, pristineMimeType, actualMimeType, propChanges, pristineProps);
            }
        }
    }

    private File getEmptyFile() throws SVNException {
        return null;
    }
}

