/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.ISVNEditor2;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbConflicts;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbPristines;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbShared;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbStatementUtil;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbStatements;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffEditor;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNTreeConflictEditor
implements ISVNEditor2 {
    private final SVNOperation operation;
    private final SVNConflictVersion oldVersion;
    private final SVNConflictVersion newVersion;
    private final SVNWCDb db;
    private final SVNWCDbRoot wcRoot;
    private final File moveRootDstRelPath;
    private ISVNEventHandler eventHandler;
    private File conflictRootRelPath;

    public SVNTreeConflictEditor(SVNWCDb db, SVNOperation operation, SVNConflictVersion oldVersion, SVNConflictVersion newVersion, SVNWCDbRoot wcRoot, File moveRootDstRelPath) {
        this.operation = operation;
        this.oldVersion = oldVersion;
        this.newVersion = newVersion;
        this.db = db;
        this.wcRoot = wcRoot;
        this.moveRootDstRelPath = moveRootDstRelPath;
    }

    @Override
    public void addDir(String path, List<String> children, SVNProperties props, long replacesRev) throws SVNException {
        SVNNodeKind oldKind;
        File moveDstReposRelPath;
        int opDepth = SVNWCUtils.relpathDepth(this.moveRootDstRelPath);
        File relPath = SVNFileUtil.createFilePath(path);
        this.db.extendParentDelete(this.wcRoot.getSDb(), this.wcRoot.getWcId(), relPath, SVNNodeKind.DIR, opDepth);
        try {
            Structure<StructureFields.NodeInfo> depthInfo = SvnWcDbShared.getDepthInfo(this.wcRoot, relPath, SVNWCUtils.relpathDepth(this.moveRootDstRelPath), new StructureFields.NodeInfo[0]);
            ISVNWCDb.SVNWCDbKind moveDstKind = (ISVNWCDb.SVNWCDbKind)((Object)depthInfo.get(StructureFields.NodeInfo.kind));
            moveDstReposRelPath = (File)depthInfo.get(StructureFields.NodeInfo.reposRelPath);
            oldKind = moveDstKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                oldKind = SVNNodeKind.NONE;
                moveDstReposRelPath = null;
            }
            throw e;
        }
        boolean isConflicted = this.checkTreeConflict(relPath, oldKind, SVNNodeKind.DIR, moveDstReposRelPath, SVNConflictAction.ADD);
        if (isConflicted) {
            return;
        }
        SVNEventAction action = SVNEventAction.ADD;
        File absPath = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), relPath);
        oldKind = SVNFileType.getNodeKind(SVNFileType.getType(absPath));
        if (oldKind == SVNNodeKind.FILE) {
            this.markTreeConflict(relPath, this.oldVersion, this.newVersion, this.moveRootDstRelPath, this.operation, oldKind, SVNNodeKind.DIR, moveDstReposRelPath, SVNConflictReason.UNVERSIONED, SVNConflictAction.ADD, null);
            this.conflictRootRelPath = relPath;
            action = SVNEventAction.TREE_CONFLICT;
            isConflicted = true;
        } else if (oldKind == SVNNodeKind.NONE) {
            SVNSkel workItem = SVNWCContext.wqBuildDirInstall(this.db, absPath);
            this.db.wqAdd(this.wcRoot.getAbsPath(), workItem);
        } else if (oldKind == SVNNodeKind.DIR) {
            // empty if block
        }
        if (!isConflicted) {
            SVNWCDb.updateMoveListAdd(this.wcRoot, relPath, action, SVNNodeKind.DIR, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE);
        }
    }

    @Override
    public void addFile(String path, SvnChecksum checksum, InputStream contents, SVNProperties props, long replacesRev) throws SVNException {
        SVNNodeKind oldKind;
        File relPath = SVNFileUtil.createFilePath(path);
        int opDepth = SVNWCUtils.relpathDepth(this.moveRootDstRelPath);
        this.db.extendParentDelete(this.wcRoot.getSDb(), this.wcRoot.getWcId(), relPath, SVNNodeKind.FILE, opDepth);
        File moveDstReposRelPath = null;
        try {
            Structure<StructureFields.NodeInfo> depthInfo = SvnWcDbShared.getDepthInfo(this.wcRoot, relPath, SVNWCUtils.relpathDepth(this.moveRootDstRelPath), new StructureFields.NodeInfo[0]);
            ISVNWCDb.SVNWCDbKind moveDstKind = (ISVNWCDb.SVNWCDbKind)((Object)depthInfo.get(StructureFields.NodeInfo.kind));
            moveDstReposRelPath = (File)depthInfo.get(StructureFields.NodeInfo.reposRelPath);
            oldKind = moveDstKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                oldKind = SVNNodeKind.NONE;
                moveDstReposRelPath = null;
            }
            throw e;
        }
        boolean isConflicted = this.checkTreeConflict(relPath, oldKind, SVNNodeKind.FILE, moveDstReposRelPath, SVNConflictAction.ADD);
        if (isConflicted) {
            return;
        }
        File absPath = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), relPath);
        oldKind = SVNFileType.getNodeKind(SVNFileType.getType(absPath));
        if (oldKind != SVNNodeKind.NONE) {
            this.markTreeConflict(relPath, this.oldVersion, this.newVersion, this.moveRootDstRelPath, this.operation, oldKind, SVNNodeKind.FILE, moveDstReposRelPath, SVNConflictReason.UNVERSIONED, SVNConflictAction.ADD, null);
            this.conflictRootRelPath = relPath;
        }
        SVNSkel workItem = SVNWCContext.wqBuildFileInstall(this.db, SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), relPath), null, false, true);
        this.db.wqAdd(this.wcRoot.getAbsPath(), workItem);
        SVNWCDb.updateMoveListAdd(this.wcRoot, relPath, SVNEventAction.UPDATE_ADD, SVNNodeKind.FILE, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE);
    }

    @Override
    public void addSymlink(String path, String target, SVNProperties props, long replacesRev) throws SVNException {
        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(errorMessage, SVNLogType.WC);
    }

    @Override
    public void addAbsent(String path, SVNNodeKind kind, long replacesRev) throws SVNException {
        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(errorMessage, SVNLogType.WC);
    }

    @Override
    public void alterDir(String path, long revision, List<String> children, SVNProperties props) throws SVNException {
        assert (revision == this.oldVersion.getPegRevision());
        File dstRelPath = SVNFileUtil.createFilePath(path);
        WorkingNodeVersion oldNodeVersion = new WorkingNodeVersion();
        WorkingNodeVersion newNodeVersion = new WorkingNodeVersion();
        Structure<StructureFields.NodeInfo> depthInfo = SvnWcDbShared.getDepthInfo(this.wcRoot, dstRelPath, SVNWCUtils.relpathDepth(this.moveRootDstRelPath), new StructureFields.NodeInfo[0]);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)depthInfo.get(StructureFields.NodeInfo.status));
        ISVNWCDb.SVNWCDbKind moveDstKind = (ISVNWCDb.SVNWCDbKind)((Object)depthInfo.get(StructureFields.NodeInfo.kind));
        File moveDstReposRelPath = (File)depthInfo.get(StructureFields.NodeInfo.reposRelPath);
        long moveDstRevision = depthInfo.lng(StructureFields.NodeInfo.revision);
        oldNodeVersion.checksum = (SvnChecksum)depthInfo.get(StructureFields.NodeInfo.checksum);
        oldNodeVersion.props = (SVNProperties)depthInfo.get(StructureFields.NodeInfo.propsMod);
        if (status == ISVNWCDb.SVNWCDbStatus.Deleted && moveDstReposRelPath != null) {
            status = ISVNWCDb.SVNWCDbStatus.NotPresent;
        }
        assert (moveDstRevision == revision || status == ISVNWCDb.SVNWCDbStatus.NotPresent);
        assert (moveDstKind == ISVNWCDb.SVNWCDbKind.Dir);
        boolean isConflicted = this.checkTreeConflict(dstRelPath, moveDstKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNNodeKind.DIR, moveDstReposRelPath, SVNConflictAction.EDIT);
        if (isConflicted) {
            return;
        }
        oldNodeVersion.locationAndKind = this.oldVersion;
        newNodeVersion.locationAndKind = this.newVersion;
        newNodeVersion.checksum = null;
        SVNProperties sVNProperties = newNodeVersion.props = props != null ? props : oldNodeVersion.props;
        if (props != null) {
            File dstAbsPath = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), dstRelPath);
            UpdateWorkingProps updateWorkingProps = this.updateWorkingProps(null, dstAbsPath, oldNodeVersion, newNodeVersion);
            SVNSkel conflictSkel = updateWorkingProps.conflictSkel;
            SVNProperties propChanges = updateWorkingProps.propChanges;
            SVNProperties actualProps = updateWorkingProps.actualProps;
            SVNStatusType propState = updateWorkingProps.propState;
            if (conflictSkel != null) {
                SVNSkel workItems = this.createConflictMarkers(dstAbsPath, moveDstReposRelPath, conflictSkel, this.operation, oldNodeVersion, newNodeVersion, SVNNodeKind.DIR);
                this.db.markConflictInternal(this.wcRoot, dstRelPath, conflictSkel);
                this.db.wqAdd(this.wcRoot.getAbsPath(), workItems);
            }
            SVNWCDb.updateMoveListAdd(this.wcRoot, dstRelPath, SVNEventAction.UPDATE_UPDATE, SVNNodeKind.DIR, SVNStatusType.INAPPLICABLE, propState);
        }
    }

    @Override
    public void alterFile(String path, long expectedMoveDstRevision, SVNProperties newProps, SvnChecksum newChecksum, InputStream newContents) throws SVNException {
        WorkingNodeVersion oldNodeVersion = new WorkingNodeVersion();
        WorkingNodeVersion newNodeVersion = new WorkingNodeVersion();
        File dstRelPath = SVNFileUtil.createFilePath(path);
        Structure<StructureFields.NodeInfo> depthInfo = SvnWcDbShared.getDepthInfo(this.wcRoot, dstRelPath, SVNWCUtils.relpathDepth(this.moveRootDstRelPath), StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.revision, StructureFields.NodeInfo.reposRelPath, StructureFields.NodeInfo.checksum, StructureFields.NodeInfo.propsMod);
        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)depthInfo.get(StructureFields.NodeInfo.status));
        ISVNWCDb.SVNWCDbKind moveDstKind = (ISVNWCDb.SVNWCDbKind)((Object)depthInfo.get(StructureFields.NodeInfo.kind));
        long moveDstRevision = depthInfo.lng(StructureFields.NodeInfo.revision);
        File moveDstReposRelPath = (File)depthInfo.get(StructureFields.NodeInfo.reposRelPath);
        oldNodeVersion.checksum = (SvnChecksum)depthInfo.get(StructureFields.NodeInfo.checksum);
        oldNodeVersion.props = (SVNProperties)depthInfo.get(StructureFields.NodeInfo.propsMod);
        if (status == ISVNWCDb.SVNWCDbStatus.Deleted && moveDstReposRelPath != null) {
            status = ISVNWCDb.SVNWCDbStatus.NotPresent;
        }
        assert (moveDstRevision == expectedMoveDstRevision || status == ISVNWCDb.SVNWCDbStatus.NotPresent);
        assert (moveDstKind == ISVNWCDb.SVNWCDbKind.File);
        boolean isConflicted = this.checkTreeConflict(dstRelPath, moveDstKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNNodeKind.FILE, moveDstReposRelPath, SVNConflictAction.EDIT);
        if (isConflicted) {
            return;
        }
        oldNodeVersion.locationAndKind = this.oldVersion;
        newNodeVersion.locationAndKind = this.newVersion;
        newNodeVersion.checksum = newChecksum != null ? newChecksum : oldNodeVersion.checksum;
        SVNProperties sVNProperties = newNodeVersion.props = newProps != null ? newProps : oldNodeVersion.props;
        if (!SvnChecksum.match(newChecksum, oldNodeVersion.checksum) || newProps != null) {
            this.updateWorkingFile(dstRelPath, moveDstReposRelPath, this.operation, oldNodeVersion, newNodeVersion);
        }
    }

    @Override
    public void alterSymlink(String path, long revision, SVNProperties props, String target) throws SVNException {
        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(errorMessage, SVNLogType.WC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String path, long revision) throws SVNException {
        boolean haveRow;
        SVNSqlJetStatement stmt;
        File moveDstReposRelPath;
        File relPath = SVNFileUtil.createFilePath(path);
        int opDepth = SVNWCUtils.relpathDepth(this.moveRootDstRelPath);
        boolean mustDeleteWorkingNode = false;
        File localAbsPath = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), relPath);
        File parentRelPath = SVNFileUtil.getFileDir(relPath);
        Structure<StructureFields.NodeInfo> depthInfo = SvnWcDbShared.getDepthInfo(this.wcRoot, relPath, SVNWCUtils.relpathDepth(this.moveRootDstRelPath), StructureFields.NodeInfo.kind, StructureFields.NodeInfo.reposRelPath);
        ISVNWCDb.SVNWCDbKind moveDstKind = (ISVNWCDb.SVNWCDbKind)((Object)depthInfo.get(StructureFields.NodeInfo.kind));
        boolean isConflicted = this.checkTreeConflict(relPath, moveDstKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNNodeKind.UNKNOWN, moveDstReposRelPath = (File)depthInfo.get(StructureFields.NodeInfo.reposRelPath), SVNConflictAction.DELETE);
        if (!isConflicted) {
            boolean isAllDeletes;
            SVNWCContext context = new SVNWCContext(this.db, this.eventHandler);
            SVNWCContext.TreeLocalModsInfo treeLocalModsInfo = context.hasLocalMods(localAbsPath, localAbsPath);
            boolean isModified = treeLocalModsInfo.modificationsFound;
            boolean bl = isAllDeletes = !treeLocalModsInfo.nonDeleteModificationsFound;
            if (isModified) {
                SVNConflictReason reason;
                if (!isAllDeletes) {
                    stmt = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.UPDATE_OP_DEPTH_RECURSIVE);
                    try {
                        stmt.bindf("isii", this.wcRoot.getWcId(), relPath, opDepth, SVNWCUtils.relpathDepth(relPath));
                        stmt.done();
                    }
                    finally {
                        stmt.reset();
                    }
                    reason = SVNConflictReason.EDITED;
                } else {
                    stmt = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.DELETE_WORKING_OP_DEPTH_ABOVE);
                    try {
                        stmt.bindf("isi", this.wcRoot.getWcId(), relPath, opDepth);
                        stmt.done();
                    }
                    finally {
                        stmt.reset();
                    }
                    reason = SVNConflictReason.DELETED;
                    mustDeleteWorkingNode = true;
                }
                isConflicted = true;
                this.markTreeConflict(relPath, this.oldVersion, this.newVersion, this.moveRootDstRelPath, this.operation, moveDstKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNNodeKind.NONE, moveDstReposRelPath, reason, SVNConflictAction.DELETE, null);
                this.conflictRootRelPath = relPath;
            }
        }
        if (!isConflicted || mustDeleteWorkingNode) {
            ISVNWCDb.SVNWCDbKind delKind;
            stmt = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_CHILDREN_OP_DEPTH);
            try {
                stmt.bindf("isi", this.wcRoot.getWcId(), relPath, opDepth);
                boolean haveRow2 = stmt.next();
                while (haveRow2) {
                    delKind = SvnWcDbStatementUtil.getColumnKind(stmt, SVNWCDbSchema.NODES__Fields.kind);
                    File delAbsPath = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), stmt.getColumnString(SVNWCDbSchema.NODES__Fields.local_relpath));
                    SVNSkel workItem = delKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNWCContext.wqBuildDirRemove(this.db, this.wcRoot.getAbsPath(), delAbsPath, false) : SVNWCContext.wqBuildFileRemove(this.db, this.wcRoot.getAbsPath(), delAbsPath);
                    this.db.wqAdd(this.wcRoot.getAbsPath(), workItem);
                    haveRow2 = stmt.next();
                }
            }
            finally {
                stmt.reset();
            }
            depthInfo = SvnWcDbShared.getDepthInfo(this.wcRoot, relPath, opDepth, StructureFields.NodeInfo.kind);
            delKind = (ISVNWCDb.SVNWCDbKind)((Object)depthInfo.get(StructureFields.NodeInfo.kind));
            SVNSkel workItem = delKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNWCContext.wqBuildDirRemove(this.db, this.wcRoot.getAbsPath(), localAbsPath, false) : SVNWCContext.wqBuildFileRemove(this.db, this.wcRoot.getAbsPath(), localAbsPath);
            this.db.wqAdd(this.wcRoot.getAbsPath(), workItem);
            if (!isConflicted) {
                SVNWCDb.updateMoveListAdd(this.wcRoot, relPath, SVNEventAction.UPDATE_DELETE, delKind == ISVNWCDb.SVNWCDbKind.Dir ? SVNNodeKind.DIR : SVNNodeKind.FILE, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE);
            }
        }
        int opDepthBelow = 0;
        stmt = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_HIGHEST_WORKING_NODE);
        try {
            stmt.bindf("isi", this.wcRoot.getWcId(), parentRelPath, opDepth);
            haveRow = stmt.next();
            if (haveRow) {
                opDepthBelow = (int)stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
            }
        }
        finally {
            stmt.reset();
        }
        if (haveRow) {
            stmt = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.DELETE_NO_LOWER_LAYER);
            try {
                stmt.bindf("isii", this.wcRoot.getWcId(), parentRelPath, opDepth, opDepthBelow);
                stmt.done();
            }
            finally {
                stmt.reset();
            }
            stmt = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.REPLACE_WITH_BASE_DELETED);
            try {
                stmt.bindf("isi", this.wcRoot.getWcId(), relPath, opDepth);
            }
            finally {
                stmt.reset();
            }
        }
        stmt = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.DELETE_WORKING_OP_DEPTH);
        try {
            stmt.bindf("isi", this.wcRoot.getWcId(), relPath, opDepth);
            stmt.done();
        }
        finally {
            stmt.reset();
        }
        this.db.retractParentDelete(this.wcRoot.getSDb(), this.wcRoot.getWcId(), relPath, opDepth);
    }

    @Override
    public void copy(String srcPath, long srcRevision, String dstPath, long replacesRev) throws SVNException {
        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(errorMessage, SVNLogType.WC);
    }

    @Override
    public void move(String srcPath, long srcRevision, String dstPath, long replacesRev) throws SVNException {
        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(errorMessage, SVNLogType.WC);
    }

    @Override
    public void rotate(List<String> relPaths, List<String> revisions) throws SVNException {
        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE);
        SVNErrorManager.error(errorMessage, SVNLogType.WC);
    }

    @Override
    public void complete() {
    }

    @Override
    public void abort() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkTreeConflict(File localRelPath, SVNNodeKind oldKind, SVNNodeKind newKind, File oldReposRelPath, SVNConflictAction action) throws SVNException {
        boolean haveRow;
        int dstOpDepth = SVNWCUtils.relpathDepth(this.moveRootDstRelPath);
        int opDepth = 0;
        if (this.conflictRootRelPath != null) {
            if (SVNPathUtil.isAncestor(SVNFileUtil.getFilePath(this.conflictRootRelPath), SVNFileUtil.getFilePath(localRelPath))) {
                return true;
            }
            this.conflictRootRelPath = null;
        }
        SVNSqlJetStatement stmt = this.wcRoot.getSDb().getStatement(SVNWCDbStatements.SELECT_LOWEST_WORKING_NODE);
        try {
            stmt.bindf("isi", this.wcRoot.getWcId(), localRelPath, dstOpDepth);
            haveRow = stmt.next();
            if (haveRow) {
                opDepth = (int)stmt.getColumnLong(SVNWCDbSchema.NODES__Fields.op_depth);
            }
        }
        finally {
            stmt.reset();
        }
        if (!haveRow) {
            return false;
        }
        boolean isConflicted = true;
        File conflictRootRelPath = localRelPath;
        while (SVNWCUtils.relpathDepth(conflictRootRelPath) > opDepth) {
            conflictRootRelPath = SVNFileUtil.getFileDir(conflictRootRelPath);
            oldKind = newKind = SVNNodeKind.DIR;
            if (oldReposRelPath != null) {
                oldReposRelPath = SVNFileUtil.getFileDir(oldReposRelPath);
            }
            action = SVNConflictAction.EDIT;
        }
        SVNWCDb.BaseMovedTo movedTo = this.db.opDepthMovedTo(dstOpDepth, this.wcRoot, conflictRootRelPath);
        File moveDstRelPath = movedTo.moveDstRelPath;
        File moveSrcOpRootRelPath = movedTo.moveSrcOpRootRelPath;
        this.markTreeConflict(conflictRootRelPath, this.oldVersion, this.newVersion, this.moveRootDstRelPath, this.operation, oldKind, newKind, oldReposRelPath, moveDstRelPath != null ? SVNConflictReason.MOVED_AWAY : SVNConflictReason.DELETED, action, moveSrcOpRootRelPath);
        this.conflictRootRelPath = conflictRootRelPath;
        return isConflicted;
    }

    private UpdateWorkingProps updateWorkingProps(SVNSkel conflictSkel, File localAbsPath, WorkingNodeVersion oldNodeVersion, WorkingNodeVersion newNodeVersion) throws SVNException {
        UpdateWorkingProps updateWorkingProps = new UpdateWorkingProps();
        if (oldNodeVersion.props == null) {
            oldNodeVersion.props = new SVNProperties();
        }
        if (newNodeVersion.props == null) {
            newNodeVersion.props = new SVNProperties();
        }
        updateWorkingProps.actualProps = this.db.readProperties(localAbsPath);
        updateWorkingProps.propChanges = SvnDiffEditor.computePropDiff(oldNodeVersion.props, newNodeVersion.props);
        SVNWCContext context = new SVNWCContext(this.db, this.eventHandler);
        SVNWCContext.MergePropertiesInfo mergePropertiesInfo = new SVNWCContext.MergePropertiesInfo();
        mergePropertiesInfo.conflictSkel = conflictSkel;
        mergePropertiesInfo = context.mergeProperties3(mergePropertiesInfo, localAbsPath, oldNodeVersion.props, oldNodeVersion.props, updateWorkingProps.actualProps, updateWorkingProps.propChanges);
        updateWorkingProps.conflictSkel = mergePropertiesInfo.conflictSkel;
        SVNProperties newActualProperties = mergePropertiesInfo.newActualProperties;
        updateWorkingProps.propState = mergePropertiesInfo.mergeOutcome;
        SVNProperties newPropChanges = SvnDiffEditor.computePropDiff(newNodeVersion.props, newActualProperties);
        if (newPropChanges.size() > 0) {
            newActualProperties = null;
        }
        this.db.opSetProps(localAbsPath, newActualProperties, null, SVNWCContext.hasMagicProperty(updateWorkingProps.propChanges), null);
        return updateWorkingProps;
    }

    private SVNSkel createConflictMarkers(File localAbsPath, File reposRelPath, SVNSkel conflictSkel, SVNOperation operation, WorkingNodeVersion oldNodeVersion, WorkingNodeVersion newNodeVersion, SVNNodeKind kind) throws SVNException {
        File part = SVNFileUtil.skipAncestor(SVNFileUtil.createFilePath(this.oldVersion.getPath()), reposRelPath);
        SVNConflictVersion originalVersion = new SVNConflictVersion(oldNodeVersion.locationAndKind.getRepositoryRoot(), SVNFileUtil.getFilePath(reposRelPath), oldNodeVersion.locationAndKind.getPegRevision(), kind);
        SVNConflictVersion conflictedVersion = new SVNConflictVersion(newNodeVersion.locationAndKind.getRepositoryRoot(), SVNPathUtil.append(oldNodeVersion.locationAndKind.getPath(), SVNFileUtil.getFilePath(part)), newNodeVersion.locationAndKind.getPegRevision(), kind);
        if (operation == SVNOperation.UPDATE) {
            SvnWcDbConflicts.conflictSkelOpUpdate(conflictSkel, originalVersion, conflictedVersion);
        } else {
            SvnWcDbConflicts.conflictSkelOpSwitch(conflictSkel, originalVersion, conflictedVersion);
        }
        SVNWCContext context = new SVNWCContext(this.db, this.eventHandler);
        return context.conflictCreateMarker(conflictSkel, localAbsPath);
    }

    private void updateWorkingFile(File localRelPath, File reposRelPath, SVNOperation operation, WorkingNodeVersion oldNodeVersion, WorkingNodeVersion newNodeVersion) throws SVNException {
        SVNStatusType contentState;
        SVNSkel workItems = null;
        File localAbsPath = SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), localRelPath);
        UpdateWorkingProps updateWorkingProps = this.updateWorkingProps(null, localAbsPath, oldNodeVersion, newNodeVersion);
        SVNSkel conflictSkel = updateWorkingProps.conflictSkel;
        SVNStatusType propState = updateWorkingProps.propState;
        SVNProperties propChanges = updateWorkingProps.propChanges;
        SVNProperties actualProps = updateWorkingProps.actualProps;
        if (!SvnChecksum.match(newNodeVersion.checksum, oldNodeVersion.checksum)) {
            SVNWCContext context = new SVNWCContext(this.db, this.eventHandler);
            boolean isLocallyModified = context.isTextModified(localAbsPath, false);
            if (!isLocallyModified) {
                SVNSkel workItem = context.wqBuildFileInstall(localAbsPath, null, false, true);
                workItems = SVNWCContext.wqMerge(workItems, workItem);
                contentState = SVNStatusType.CHANGED;
            } else {
                File oldPristineAbsPath = SvnWcDbPristines.getPristinePath(this.wcRoot, oldNodeVersion.checksum);
                File newPristineAbsPath = SvnWcDbPristines.getPristinePath(this.wcRoot, newNodeVersion.checksum);
                SVNWCContext.MergeInfo mergeInfo = context.merge(workItems, conflictSkel, oldPristineAbsPath, newPristineAbsPath, localAbsPath, localAbsPath, null, null, null, actualProps, false, null, propChanges);
                conflictSkel = mergeInfo.conflictSkel;
                SVNSkel workItem = mergeInfo.workItems;
                SVNStatusType mergeOutcome = mergeInfo.mergeOutcome;
                workItems = SVNWCContext.wqMerge(workItems, workItem);
                contentState = mergeOutcome == SVNStatusType.CONFLICTED ? SVNStatusType.CONFLICTED : SVNStatusType.MERGED;
            }
        } else {
            contentState = SVNStatusType.UNCHANGED;
        }
        if (conflictSkel != null) {
            SVNSkel workItem = this.createConflictMarkers(localAbsPath, reposRelPath, conflictSkel, operation, oldNodeVersion, newNodeVersion, SVNNodeKind.FILE);
            this.db.markConflictInternal(this.wcRoot, localRelPath, conflictSkel);
            workItems = SVNWCContext.wqMerge(workItems, workItem);
        }
        this.db.wqAdd(this.wcRoot.getAbsPath(), workItems);
        SVNWCDb.updateMoveListAdd(this.wcRoot, localRelPath, SVNEventAction.UPDATE_UPDATE, SVNNodeKind.FILE, contentState, propState);
    }

    private void markTreeConflict(File localRelPath, SVNConflictVersion oldVersion, SVNConflictVersion newVersion, File moveRootDstRelPath, SVNOperation operation, SVNNodeKind oldKind, SVNNodeKind newKind, File oldReposRelPath, SVNConflictReason reason, SVNConflictAction action, File moveSrcOpRootRelPath) throws SVNException {
        SVNSkel conflictSkel;
        File newReposRelPath;
        File moveSrcOpRootAbsPath = moveSrcOpRootRelPath != null ? SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), moveSrcOpRootRelPath) : null;
        File oldReposRelPathPart = oldReposRelPath != null ? SVNFileUtil.skipAncestor(SVNFileUtil.createFilePath(oldVersion.getPath()), oldReposRelPath) : null;
        File file = newReposRelPath = oldReposRelPathPart != null ? SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(newVersion.getPath()), oldReposRelPathPart) : null;
        if (newReposRelPath == null) {
            newReposRelPath = SVNFileUtil.createFilePath(newVersion.getPath(), SVNFileUtil.getFilePath(SVNFileUtil.skipAncestor(moveRootDstRelPath, localRelPath)));
        }
        try {
            conflictSkel = this.db.readConflictInternal(this.wcRoot, localRelPath);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                conflictSkel = null;
            }
            throw e;
        }
        if (conflictSkel != null) {
            Structure<SvnWcDbConflicts.ConflictInfo> conflictInfoStructure = SvnWcDbConflicts.readConflictInfo(conflictSkel);
            SVNOperation conflictOperation = (SVNOperation)conflictInfoStructure.get(SvnWcDbConflicts.ConflictInfo.conflictOperation);
            boolean treeConflicted = conflictInfoStructure.is(SvnWcDbConflicts.ConflictInfo.treeConflicted);
            if (conflictOperation != SVNOperation.UPDATE && conflictOperation != SVNOperation.SWITCH) {
                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "'{0}' already in conflict", (Object)localRelPath);
                SVNErrorManager.error(errorMessage, SVNLogType.WC);
            }
            if (treeConflicted) {
                Structure<SvnWcDbConflicts.TreeConflictInfo> treeConflictInfoStructure = SvnWcDbConflicts.readTreeConflict(this.db, this.wcRoot.getAbsPath(), conflictSkel);
                SVNConflictReason existingReason = (SVNConflictReason)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.localChange);
                SVNConflictAction existingAction = (SVNConflictAction)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.incomingChange);
                File existingAbsPath = (File)treeConflictInfoStructure.get(SvnWcDbConflicts.TreeConflictInfo.moveSrcOpRootAbsPath);
                if (reason != existingReason || action != existingAction || reason == SVNConflictReason.MOVED_AWAY && !moveSrcOpRootRelPath.equals(SVNFileUtil.skipAncestor(this.wcRoot.getAbsPath(), existingAbsPath))) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_CONFLICT_RESOLVER_FAILURE, "'{0}' already in conflict", (Object)localRelPath);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                return;
            }
        } else {
            conflictSkel = SvnWcDbConflicts.createConflictSkel();
        }
        SvnWcDbConflicts.addTreeConflict(conflictSkel, this.db, SVNFileUtil.createFilePath(this.wcRoot.getAbsPath(), localRelPath), reason, action, moveSrcOpRootAbsPath);
        SVNConflictVersion conflictOldVersion = reason != SVNConflictReason.UNVERSIONED && oldReposRelPath != null ? new SVNConflictVersion(oldVersion.getRepositoryRoot(), SVNFileUtil.getFilePath(oldReposRelPath), oldVersion.getPegRevision(), oldKind) : null;
        SVNConflictVersion conflictNewVersion = new SVNConflictVersion(newVersion.getRepositoryRoot(), SVNFileUtil.getFilePath(newReposRelPath), newVersion.getPegRevision(), newKind);
        if (operation == SVNOperation.UPDATE) {
            SvnWcDbConflicts.conflictSkelOpUpdate(conflictSkel, conflictOldVersion, conflictNewVersion);
        } else {
            assert (operation == SVNOperation.SWITCH);
            SvnWcDbConflicts.conflictSkelOpSwitch(conflictSkel, conflictOldVersion, conflictNewVersion);
        }
        this.db.markConflictInternal(this.wcRoot, localRelPath, conflictSkel);
        SVNWCDb.updateMoveListAdd(this.wcRoot, localRelPath, SVNEventAction.TREE_CONFLICT, newKind, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE);
    }

    private static class WorkingNodeVersion {
        SVNConflictVersion locationAndKind;
        SVNProperties props;
        SvnChecksum checksum;

        private WorkingNodeVersion() {
        }
    }

    private static class UpdateWorkingProps {
        SVNStatusType propState;
        SVNSkel conflictSkel;
        SVNProperties propChanges;
        SVNProperties actualProps;

        private UpdateWorkingProps() {
        }
    }
}

