/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNSkel;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDbRoot;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.util.ISVNDebugLog;

public class SVNReporter17
implements ISVNReporterBaton {
    private final File path;
    private SVNWCContext wcContext;
    private SVNDepth depth;
    private final boolean isRestoreFiles;
    private final boolean isUseDepthCompatibilityTrick;
    private final boolean isHonorDepthExclude;
    private boolean isUseCommitTimes;
    private int reportedFilesCount;
    private int totalFilesCount;

    public SVNReporter17(File path, SVNWCContext wcContext, boolean restoreFiles, boolean useDepthCompatibilityTrick, SVNDepth depth, boolean lockOnDemand, boolean isStatus, boolean isHonorDepthExclude, boolean isUseCommitTimes, ISVNDebugLog log) {
        this.path = path;
        this.wcContext = wcContext;
        this.isRestoreFiles = restoreFiles;
        this.isUseDepthCompatibilityTrick = useDepthCompatibilityTrick;
        this.depth = depth;
        this.isHonorDepthExclude = isHonorDepthExclude;
        this.isUseCommitTimes = isUseCommitTimes;
    }

    public int getReportedFilesCount() {
        return this.reportedFilesCount;
    }

    public int getTotalFilesCount() {
        return this.totalFilesCount;
    }

    @Override
    public void report(ISVNReporter reporter) throws SVNException {
        boolean start_empty;
        assert (SVNWCDb.isAbsolute(this.path));
        ISVNWCDb.SVNWCDbStatus status = null;
        ISVNWCDb.SVNWCDbKind target_kind = null;
        long target_rev = 0L;
        File repos_relpath = null;
        SVNURL repos_root = null;
        SVNDepth target_depth = SVNDepth.UNKNOWN;
        ISVNWCDb.SVNWCDbLock target_lock = null;
        SVNErrorMessage err = null;
        try {
            ISVNWCDb.WCDbBaseInfo baseInfo = this.wcContext.getDb().getBaseInfo(this.path, ISVNWCDb.WCDbBaseInfo.BaseInfoField.status, ISVNWCDb.WCDbBaseInfo.BaseInfoField.kind, ISVNWCDb.WCDbBaseInfo.BaseInfoField.revision, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRootUrl, ISVNWCDb.WCDbBaseInfo.BaseInfoField.depth, ISVNWCDb.WCDbBaseInfo.BaseInfoField.lock);
            status = baseInfo.status;
            target_kind = baseInfo.kind;
            target_rev = baseInfo.revision;
            repos_relpath = baseInfo.reposRelPath;
            repos_root = baseInfo.reposRootUrl;
            target_depth = baseInfo.depth;
            target_lock = baseInfo.lock;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            err = e.getErrorMessage();
        }
        if (err != null || status != ISVNWCDb.SVNWCDbStatus.Normal && status != ISVNWCDb.SVNWCDbStatus.Incomplete) {
            if (this.depth == SVNDepth.UNKNOWN) {
                this.depth = SVNDepth.INFINITY;
            }
            reporter.setPath("", null, 0L, this.depth, false);
            reporter.deletePath("");
            reporter.finishReport();
            return;
        }
        if (target_depth == SVNDepth.UNKNOWN) {
            target_depth = SVNDepth.INFINITY;
        }
        boolean bl = start_empty = status == ISVNWCDb.SVNWCDbStatus.Incomplete;
        if (this.isUseDepthCompatibilityTrick && target_depth.compareTo(SVNDepth.IMMEDIATES) <= 0 && this.depth.compareTo(target_depth) > 0) {
            start_empty = true;
        }
        SVNFileType diskType = SVNFileType.UNKNOWN;
        if (this.isRestoreFiles) {
            diskType = SVNFileType.getType(this.path);
        }
        if (this.isRestoreFiles && diskType == SVNFileType.NONE) {
            SvnChecksum checksum;
            ISVNWCDb.SVNWCDbKind wrkKind;
            ISVNWCDb.SVNWCDbStatus wrkStatus;
            ISVNWCDb.WCDbInfo wInfo = null;
            try {
                wInfo = this.wcContext.getDb().readInfo(this.path, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.checksum);
                wrkStatus = wInfo.status;
                wrkKind = wInfo.kind;
                checksum = wInfo.checksum;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    wrkStatus = ISVNWCDb.SVNWCDbStatus.NotPresent;
                    wrkKind = ISVNWCDb.SVNWCDbKind.File;
                    checksum = null;
                }
                throw e;
            }
            if (!(wrkStatus != ISVNWCDb.SVNWCDbStatus.Normal && wrkStatus != ISVNWCDb.SVNWCDbStatus.Added && wrkStatus != ISVNWCDb.SVNWCDbStatus.Incomplete || wrkKind != ISVNWCDb.SVNWCDbKind.Dir && checksum == null)) {
                SVNReporter17.restoreNode(this.wcContext, this.path, wrkKind, target_rev, this.isUseCommitTimes);
            }
        }
        try {
            SVNDepth reportDepth = target_depth;
            if (this.isHonorDepthExclude && this.depth != SVNDepth.UNKNOWN && this.depth.compareTo(target_depth) < 0) {
                reportDepth = this.depth;
            }
            reporter.setPath("", null, target_rev, reportDepth, start_empty);
            if (target_kind == ISVNWCDb.SVNWCDbKind.Dir) {
                if (this.depth != SVNDepth.EMPTY) {
                    SVNWCDb.DirParsedInfo rootInfo = ((SVNWCDb)this.wcContext.getDb()).obtainWcRoot(this.path);
                    this.reportRevisionsAndDepths(rootInfo.wcDbDir.getWCRoot(), this.path, rootInfo.localRelPath, SVNFileUtil.createFilePath(""), target_rev, repos_relpath, repos_root, reportDepth, reporter, this.isRestoreFiles, this.depth, start_empty);
                }
            } else if (target_kind == ISVNWCDb.SVNWCDbKind.Symlink || target_kind == ISVNWCDb.SVNWCDbKind.File) {
                String base = SVNFileUtil.getFileName(this.path);
                File parentPath = SVNFileUtil.getParentFile(this.path);
                ISVNWCDb.WCDbBaseInfo parentInfo = this.wcContext.getDb().getBaseInfo(parentPath, ISVNWCDb.WCDbBaseInfo.BaseInfoField.reposRelPath);
                if (!repos_relpath.equals(SVNFileUtil.createFilePath(parentInfo.reposRelPath, base))) {
                    SVNURL url = SVNWCUtils.join(repos_root, repos_relpath);
                    reporter.linkPath(url, "", target_lock != null ? target_lock.token : null, target_rev, SVNDepth.INFINITY, false);
                } else if (target_lock != null) {
                    reporter.setPath("", target_lock.token, target_rev, SVNDepth.INFINITY, false);
                }
            }
            reporter.finishReport();
        }
        catch (SVNException e) {
            try {
                reporter.abortReport();
            }
            catch (SVNException inner) {
                e.getErrorMessage().setChildErrorMessage(inner.getErrorMessage());
            }
            throw e;
        }
    }

    public static boolean restoreNode(SVNWCContext context, File local_abspath, ISVNWCDb.SVNWCDbKind kind, long target_rev, boolean useCommitTimes) throws SVNException {
        boolean restored = false;
        if (kind == ISVNWCDb.SVNWCDbKind.File || kind == ISVNWCDb.SVNWCDbKind.Symlink) {
            SVNReporter17.restoreFile(context, local_abspath, useCommitTimes, true);
            restored = true;
        } else if (kind == ISVNWCDb.SVNWCDbKind.Dir) {
            local_abspath.mkdirs();
            restored = true;
        }
        if (restored && context.getEventHandler() != null) {
            context.getEventHandler().handleEvent(SVNEventFactory.createSVNEvent(local_abspath, SVNNodeKind.FILE, null, target_rev, SVNEventAction.RESTORE, null, null, null), 0.0);
        }
        return restored;
    }

    private void reportRevisionsAndDepths(SVNWCDbRoot root, File dirPath, File dirLocalRelPath, File reportRelPath, long dirRev, File dirReposRelPath, SVNURL dirReposRoot, SVNDepth dirDepth, ISVNReporter reporter, boolean restoreFiles, SVNDepth depth, boolean reportEverything) throws SVNException {
        Map<String, ISVNWCDb.WCDbBaseInfo> baseChildren = this.wcContext.getDb().getBaseChildrenMap(root, dirLocalRelPath, true);
        HashSet<String> dirEntries = null;
        if (restoreFiles) {
            dirEntries = new HashSet<String>();
            File[] list = SVNFileListUtil.listFiles(dirPath);
            if (list != null) {
                for (File file : list) {
                    dirEntries.add(SVNFileUtil.getFileName(file));
                }
            } else {
                SVNFileType fileType = SVNFileType.getType(dirPath);
                if (fileType != SVNFileType.DIRECTORY) {
                    restoreFiles = false;
                }
            }
        }
        for (String child : baseChildren.keySet()) {
            boolean isIncomplete;
            boolean thisSwitched = false;
            this.wcContext.checkCancelled();
            String thisReportRelpath = SVNFileUtil.getFilePath(SVNFileUtil.createFilePath(reportRelPath, child));
            File thisAbsPath = SVNFileUtil.createFilePath(dirPath, child);
            ISVNWCDb.WCDbBaseInfo ths = baseChildren.get(child);
            if (ths.updateRoot) continue;
            if (ths.status == ISVNWCDb.SVNWCDbStatus.Excluded) {
                if (this.isHonorDepthExclude) {
                    reporter.setPath(thisReportRelpath, null, dirRev, SVNDepth.EXCLUDE, false);
                    continue;
                }
                if (reportEverything) continue;
                reporter.deletePath(thisReportRelpath);
                continue;
            }
            if (ths.status == ISVNWCDb.SVNWCDbStatus.ServerExcluded || ths.status == ISVNWCDb.SVNWCDbStatus.NotPresent) {
                if (reportEverything) continue;
                reporter.deletePath(thisReportRelpath);
                continue;
            }
            if (restoreFiles && !dirEntries.contains(child)) {
                SvnChecksum checksum;
                ISVNWCDb.SVNWCDbKind wrkKind;
                ISVNWCDb.SVNWCDbStatus wrkStatus;
                ISVNWCDb.WCDbInfo wInfo = null;
                try {
                    wInfo = this.wcContext.getDb().readInfo(thisAbsPath, ISVNWCDb.WCDbInfo.InfoField.status, ISVNWCDb.WCDbInfo.InfoField.kind, ISVNWCDb.WCDbInfo.InfoField.checksum);
                    wrkStatus = wInfo.status;
                    wrkKind = wInfo.kind;
                    checksum = wInfo.checksum;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                        wrkStatus = ISVNWCDb.SVNWCDbStatus.NotPresent;
                        wrkKind = ISVNWCDb.SVNWCDbKind.File;
                        checksum = null;
                    }
                    throw e;
                }
                if (!(wrkStatus != ISVNWCDb.SVNWCDbStatus.Normal && wrkStatus != ISVNWCDb.SVNWCDbStatus.Added && wrkStatus != ISVNWCDb.SVNWCDbStatus.Incomplete || wrkKind != ISVNWCDb.SVNWCDbKind.Dir && checksum == null || SVNFileType.getType(thisAbsPath) != SVNFileType.NONE)) {
                    SVNReporter17.restoreNode(this.wcContext, thisAbsPath, wrkKind, dirRev, this.isUseCommitTimes);
                }
            }
            if (ths.reposRelPath == null) {
                ths.reposRelPath = SVNFileUtil.createFilePath(dirReposRelPath, child);
            } else {
                String childName = SVNWCUtils.getPathAsChild(dirReposRelPath, ths.reposRelPath);
                if (childName == null || !child.equals(childName)) {
                    thisSwitched = true;
                }
            }
            if (ths.depth == SVNDepth.UNKNOWN) {
                ths.depth = SVNDepth.INFINITY;
            }
            if (ths.kind == ISVNWCDb.SVNWCDbKind.File || ths.kind == ISVNWCDb.SVNWCDbKind.Symlink) {
                SVNURL url;
                if (reportEverything) {
                    if (thisSwitched) {
                        url = SVNWCUtils.join(dirReposRoot, ths.reposRelPath);
                        reporter.linkPath(url, thisReportRelpath, ths.lock != null ? ths.lock.token : null, ths.revision, ths.depth, false);
                        continue;
                    }
                    reporter.setPath(thisReportRelpath, ths.lock != null ? ths.lock.token : null, ths.revision, ths.depth, false);
                    continue;
                }
                if (thisSwitched) {
                    url = SVNWCUtils.join(dirReposRoot, ths.reposRelPath);
                    reporter.linkPath(url, thisReportRelpath, ths.lock != null ? ths.lock.token : null, ths.revision, ths.depth, false);
                    continue;
                }
                if (ths.revision == dirRev && ths.lock == null && dirDepth != SVNDepth.EMPTY) continue;
                reporter.setPath(thisReportRelpath, ths.lock != null ? ths.lock.token : null, ths.revision, ths.depth, false);
                continue;
            }
            if (ths.kind != ISVNWCDb.SVNWCDbKind.Dir || depth != SVNDepth.UNKNOWN && depth.compareTo(SVNDepth.FILES) <= 0) continue;
            boolean startEmpty = isIncomplete = ths.status == ISVNWCDb.SVNWCDbStatus.Incomplete;
            SVNDepth reportDepth = ths.depth;
            if (!depth.isRecursive()) {
                reportDepth = SVNDepth.EMPTY;
            }
            if (isIncomplete && ths.revision < 0L) {
                ths.revision = dirRev;
            }
            if (this.isUseDepthCompatibilityTrick && ths.depth.compareTo(SVNDepth.FILES) <= 0 && depth.compareTo(ths.depth) > 0) {
                startEmpty = true;
            }
            if (reportEverything) {
                if (thisSwitched) {
                    url = SVNWCUtils.join(dirReposRoot, ths.reposRelPath);
                    reporter.linkPath(url, thisReportRelpath, ths.lock != null ? ths.lock.token : null, ths.revision, reportDepth, startEmpty);
                } else {
                    reporter.setPath(thisReportRelpath, ths.lock != null ? ths.lock.token : null, ths.revision, reportDepth, startEmpty);
                }
            } else if (thisSwitched) {
                url = SVNWCUtils.join(dirReposRoot, ths.reposRelPath);
                reporter.linkPath(url, thisReportRelpath, ths.lock != null ? ths.lock.token : null, ths.revision, reportDepth, startEmpty);
            } else if (ths.revision != dirRev || isIncomplete || ths.lock != null || dirDepth == SVNDepth.EMPTY || dirDepth == SVNDepth.FILES || dirDepth == SVNDepth.IMMEDIATES && ths.depth != SVNDepth.EMPTY || ths.depth.compareTo(SVNDepth.INFINITY) < 0 && depth.isRecursive()) {
                reporter.setPath(thisReportRelpath, ths.lock != null ? ths.lock.token : null, ths.revision, reportDepth, startEmpty);
            }
            if (!depth.isRecursive()) continue;
            File reposRelPath = ths.reposRelPath;
            if (reposRelPath == null) {
                reposRelPath = SVNFileUtil.createFilePath(dirReposRelPath, child);
            }
            this.reportRevisionsAndDepths(root, thisAbsPath, SVNFileUtil.createFilePath(dirLocalRelPath, child), SVNFileUtil.createFilePath(thisReportRelpath), ths.revision, reposRelPath, dirReposRoot, ths.depth, reporter, restoreFiles, depth, startEmpty);
        }
    }

    private static void restoreFile(SVNWCContext context, File localAbsPath, boolean useCommitTimes, boolean removeTextConflicts) throws SVNException {
        SVNSkel workItem = context.wqBuildFileInstall(localAbsPath, null, useCommitTimes, true);
        context.getDb().addWorkQueue(localAbsPath, workItem);
        context.wqRun(localAbsPath);
        if (removeTextConflicts) {
            SVNReporter17.resolveTextConflict(context, localAbsPath);
        }
    }

    private static void resolveTextConflict(SVNWCContext context, File localAbsPath) throws SVNException {
        context.resolveConflictOnNode(localAbsPath, true, false, SVNConflictChoice.MERGED);
    }
}

