/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.ISVNCommitPathHandler;
import org.tmatesoft.svn.core.internal.wc.SVNCommitUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumOutputStream;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnChecksum;
import org.tmatesoft.svn.core.wc2.SvnCommitItem;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommitter17
implements ISVNCommitPathHandler {
    private SVNWCContext myContext;
    private Map<String, SvnCommitItem> myCommittables;
    private SVNURL myRepositoryRoot;
    private Map<File, SvnChecksum> myMd5Checksums;
    private Map<File, SvnChecksum> mySha1Checksums;
    private Map<String, SvnCommitItem> myModifiedFiles;
    private SVNDeltaGenerator myDeltaGenerator;
    private Collection<File> deletedPaths;

    public SVNCommitter17(SVNWCContext context, Map<String, SvnCommitItem> committables, SVNURL repositoryRoot, Collection<File> tmpFiles, Map<File, SvnChecksum> md5Checksums, Map<File, SvnChecksum> sha1Checksums) {
        this.myContext = context;
        this.myCommittables = committables;
        this.myRepositoryRoot = repositoryRoot;
        this.myMd5Checksums = md5Checksums;
        this.mySha1Checksums = sha1Checksums;
        this.myModifiedFiles = new TreeMap<String, SvnCommitItem>();
        this.deletedPaths = new TreeSet<File>();
    }

    public static SVNCommitInfo commit(SVNWCContext context, Collection<File> tmpFiles, Map<String, SvnCommitItem> committables, SVNURL repositoryRoot, ISVNEditor commitEditor, Map<File, SvnChecksum> md5Checksums, Map<File, SvnChecksum> sha1Checksums) throws SVNException {
        SVNCommitter17 committer = new SVNCommitter17(context, committables, repositoryRoot, tmpFiles, md5Checksums, sha1Checksums);
        SVNCommitUtil.driveCommitEditor(committer, committables.keySet(), commitEditor, -1L);
        committer.sendTextDeltas(commitEditor);
        return commitEditor.closeEdit();
    }

    public Collection<File> getDeletedPaths() {
        return this.deletedPaths;
    }

    @Override
    public boolean handleCommitPath(String commitPath, ISVNEditor commitEditor) throws SVNException {
        SvnCommitItem item = this.myCommittables.get(commitPath);
        this.myContext.checkCancelled();
        if (item.hasFlag(16)) {
            if (item.getCopyFromUrl() == null) {
                err = SVNErrorMessage.create(SVNErrorCode.BAD_URL, "Commit item ''{0}'' has copy flag but no copyfrom URL", (Object)item.getPath());
                SVNErrorManager.error(err, SVNLogType.WC);
            } else if (item.getCopyFromRevision() < 0L) {
                err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Commit item ''{0}'' has copy flag but an invalid revision", (Object)item.getPath());
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        boolean closeDir = false;
        File localAbspath = null;
        if (item.getKind() != SVNNodeKind.NONE && item.getPath() != null) {
            localAbspath = item.getPath();
        }
        long rev = item.getRevision();
        SVNEvent event = null;
        if (item.hasFlag(1) && item.hasFlag(2)) {
            event = SVNEventFactory.createSVNEvent(localAbspath, item.getKind(), null, -1L, SVNEventAction.COMMIT_REPLACED, null, null, null);
            event.setPreviousRevision(rev);
        } else if (item.hasFlag(2)) {
            event = SVNEventFactory.createSVNEvent(localAbspath, item.getKind(), null, -1L, SVNEventAction.COMMIT_DELETED, null, null, null);
            event.setPreviousRevision(rev);
        } else if (item.hasFlag(1)) {
            String mimeType = null;
            if (item.getKind() == SVNNodeKind.FILE && localAbspath != null) {
                mimeType = this.myContext.getProperty(localAbspath, "svn:mime-type");
            }
            event = SVNEventFactory.createSVNEvent(localAbspath, item.getKind(), mimeType, -1L, SVNEventAction.COMMIT_ADDED, null, null, null);
            event.setPreviousRevision(item.getCopyFromRevision() >= 0L ? item.getCopyFromRevision() : -1L);
            event.setPreviousURL(item.getCopyFromUrl());
        } else if (item.hasFlag(4) || item.hasFlag(8)) {
            SVNStatusType contentState = SVNStatusType.UNCHANGED;
            if (item.hasFlag(4)) {
                contentState = SVNStatusType.CHANGED;
            }
            SVNStatusType propState = SVNStatusType.UNCHANGED;
            if (item.hasFlag(8)) {
                propState = SVNStatusType.CHANGED;
            }
            event = SVNEventFactory.createSVNEvent(localAbspath, item.getKind(), null, -1L, contentState, propState, null, SVNEventAction.COMMIT_MODIFIED, null, null, null);
            event.setPreviousRevision(rev);
        }
        if (event != null) {
            event.setURL(item.getUrl());
            if (this.myContext.getEventHandler() != null) {
                this.myContext.getEventHandler().handleEvent(event, -1.0);
            }
        }
        if (item.hasFlag(2)) {
            try {
                commitEditor.deleteEntry(commitPath, rev);
            }
            catch (SVNException e) {
                this.fixError(localAbspath, commitPath, e, item.getKind());
            }
            if (!item.hasFlag(1)) {
                this.deletedPaths.add(localAbspath);
            }
        }
        long cfRev = item.getCopyFromRevision();
        Map<String, SVNPropertyValue> outgoingProperties = item.getOutgoingProperties();
        boolean fileOpen = false;
        if (item.hasFlag(1)) {
            String copyFromPath = this.getCopyFromPath(item.getCopyFromUrl());
            if (item.getKind() == SVNNodeKind.FILE) {
                commitEditor.addFile(commitPath, copyFromPath, cfRev);
                fileOpen = true;
            } else {
                commitEditor.addDir(commitPath, copyFromPath, cfRev);
                closeDir = true;
            }
            if (outgoingProperties != null) {
                for (String propName : outgoingProperties.keySet()) {
                    SVNPropertyValue propValue = outgoingProperties.get(propName);
                    if (item.getKind() == SVNNodeKind.FILE) {
                        commitEditor.changeFileProperty(commitPath, propName, propValue);
                        continue;
                    }
                    commitEditor.changeDirProperty(propName, propValue);
                }
                outgoingProperties = null;
            }
        }
        if (item.hasFlag(8)) {
            if (item.getKind() == SVNNodeKind.FILE) {
                if (!fileOpen) {
                    try {
                        commitEditor.openFile(commitPath, rev);
                    }
                    catch (SVNException e) {
                        this.fixError(localAbspath, commitPath, e, SVNNodeKind.FILE);
                    }
                }
                fileOpen = true;
            } else if (!item.hasFlag(1)) {
                try {
                    if ("".equals(commitPath)) {
                        commitEditor.openRoot(rev);
                    } else {
                        commitEditor.openDir(commitPath, rev);
                    }
                }
                catch (SVNException svne) {
                    this.fixError(localAbspath, commitPath, svne, SVNNodeKind.DIR);
                }
                closeDir = true;
            }
            if (item.hasFlag(8)) {
                try {
                    this.sendPropertiesDelta(localAbspath, commitPath, item, commitEditor);
                }
                catch (SVNException e) {
                    this.fixError(localAbspath, commitPath, e, item.getKind());
                }
            }
            if (outgoingProperties != null) {
                for (String propName : outgoingProperties.keySet()) {
                    SVNPropertyValue propValue = outgoingProperties.get(propName);
                    if (item.getKind() == SVNNodeKind.FILE) {
                        commitEditor.changeFileProperty(commitPath, propName, propValue);
                        continue;
                    }
                    commitEditor.changeDirProperty(propName, propValue);
                }
            }
        }
        if (item.hasFlag(4) && item.getKind() == SVNNodeKind.FILE) {
            if (!fileOpen) {
                try {
                    commitEditor.openFile(commitPath, rev);
                }
                catch (SVNException e) {
                    this.fixError(localAbspath, commitPath, e, SVNNodeKind.FILE);
                }
            }
            this.myModifiedFiles.put(commitPath, item);
        } else if (fileOpen) {
            try {
                commitEditor.closeFile(commitPath, null);
            }
            catch (SVNException e) {
                this.fixError(localAbspath, commitPath, e, SVNNodeKind.FILE);
            }
        }
        return closeDir;
    }

    private void fixError(File localAbspath, String path, SVNException e, SVNNodeKind kind) throws SVNException {
        SVNErrorMessage err = e.getErrorMessage();
        if (err.getErrorCode() == SVNErrorCode.FS_NOT_FOUND || err.getErrorCode() == SVNErrorCode.FS_ALREADY_EXISTS || err.getErrorCode() == SVNErrorCode.FS_TXN_OUT_OF_DATE || err.getErrorCode() == SVNErrorCode.RA_DAV_PATH_NOT_FOUND || err.getErrorCode() == SVNErrorCode.RA_DAV_ALREADY_EXISTS || err.hasChildWithErrorCode(SVNErrorCode.RA_OUT_OF_DATE)) {
            SVNEvent event;
            if (this.myContext.getEventHandler() != null && (event = localAbspath != null ? SVNEventFactory.createSVNEvent(localAbspath, kind, null, -1L, SVNEventAction.FAILED_OUT_OF_DATE, null, err, null) : null) != null) {
                this.myContext.getEventHandler().handleEvent(event, -1.0);
            }
            err = SVNErrorMessage.create(SVNErrorCode.WC_NOT_UP_TO_DATE, kind == SVNNodeKind.DIR ? "Directory ''{0}'' is out of date" : "File ''{0}'' is out of date", (Object)localAbspath);
            throw new SVNException(err);
        }
        if (err.hasChildWithErrorCode(SVNErrorCode.FS_NO_LOCK_TOKEN) || err.getErrorCode() == SVNErrorCode.FS_LOCK_OWNER_MISMATCH || err.getErrorCode() == SVNErrorCode.RA_NOT_LOCKED) {
            SVNEvent event;
            if (this.myContext.getEventHandler() != null && (event = localAbspath != null ? SVNEventFactory.createSVNEvent(localAbspath, kind, null, -1L, SVNEventAction.FAILED_LOCKED, null, err, null) : null) != null) {
                this.myContext.getEventHandler().handleEvent(event, -1.0);
            }
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NO_LOCK_TOKEN, kind == SVNNodeKind.DIR ? "Directory ''{0}'' is locked in another working copy" : "File ''{0}'' is locked in another working copy", (Object)localAbspath);
            throw new SVNException(err);
        }
        if ((err.hasChildWithErrorCode(SVNErrorCode.RA_DAV_FORBIDDEN) || err.getErrorCode() == SVNErrorCode.AUTHZ_UNWRITABLE) && this.myContext.getEventHandler() != null) {
            SVNEvent event = localAbspath != null ? SVNEventFactory.createSVNEvent(localAbspath, kind, null, -1L, SVNEventAction.FAILED_FORBIDDEN_BY_SERVER, null, err, null) : null;
            if (event != null) {
                this.myContext.getEventHandler().handleEvent(event, -1.0);
            }
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_FORBIDDEN_BY_SERVER, kind == SVNNodeKind.DIR ? "Changing directory ''{0}'' is forbidden by the server" : "Changing file ''{0}'' is forbidden by the server", (Object)localAbspath);
            throw new SVNException(err);
        }
        throw e;
    }

    private String getCopyFromPath(SVNURL url) {
        if (url == null) {
            return null;
        }
        String path = url.getPath();
        if (this.myRepositoryRoot.getPath().equals(path)) {
            return "/";
        }
        return path.substring(this.myRepositoryRoot.getPath().length());
    }

    private void sendPropertiesDelta(File localAbspath, String commitPath, SvnCommitItem item, ISVNEditor commitEditor) throws SVNException {
        SVNNodeKind kind = this.myContext.readKind(localAbspath, false);
        SVNProperties propMods = this.myContext.getPropDiffs((File)localAbspath).propChanges;
        Iterator<String> iterator = propMods.nameSet().iterator();
        while (iterator.hasNext()) {
            String i;
            String propName = i = iterator.next();
            SVNPropertyValue propValue = propMods.getSVNPropertyValue(propName);
            if (kind == SVNNodeKind.FILE) {
                commitEditor.changeFileProperty(commitPath, propName, propValue);
                continue;
            }
            commitEditor.changeDirProperty(propName, propValue);
        }
    }

    public void sendTextDeltas(ISVNEditor editor) throws SVNException {
        for (String path : this.myModifiedFiles.keySet()) {
            SvnCommitItem item = this.myModifiedFiles.get(path);
            this.myContext.checkCancelled();
            File itemAbspath = item.getPath();
            if (this.myContext.getEventHandler() != null) {
                SVNEvent event = SVNEventFactory.createSVNEvent(itemAbspath, SVNNodeKind.FILE, null, -1L, SVNEventAction.COMMIT_DELTA_SENT, null, null, null);
                this.myContext.getEventHandler().handleEvent(event, -1.0);
            }
            boolean fulltext = item.hasFlag(1);
            TransmittedChecksums transmitTextDeltas = this.transmitTextDeltas(path, itemAbspath, fulltext, editor);
            SvnChecksum newTextBaseMd5Checksum = transmitTextDeltas.md5Checksum;
            SvnChecksum newTextBaseSha1Checksum = transmitTextDeltas.sha1Checksum;
            if (this.myMd5Checksums != null) {
                this.myMd5Checksums.put(itemAbspath, newTextBaseMd5Checksum);
            }
            if (this.mySha1Checksums == null) continue;
            this.mySha1Checksums.put(itemAbspath, newTextBaseSha1Checksum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransmittedChecksums transmitTextDeltas(String path, File localAbspath, boolean fulltext, ISVNEditor editor) throws SVNException {
        InputStream localStream = SVNFileUtil.DUMMY_IN;
        InputStream baseStream = SVNFileUtil.DUMMY_IN;
        SvnChecksum expectedMd5Checksum = null;
        SvnChecksum localMd5Checksum = null;
        SvnChecksum verifyChecksum = null;
        SVNChecksumOutputStream localSha1ChecksumStream = null;
        SVNChecksumInputStream verifyChecksumStream = null;
        SVNErrorMessage error = null;
        File newPristineTmpAbspath = null;
        try {
            localStream = this.myContext.getTranslatedStream(localAbspath, localAbspath, true, false);
            SVNWCContext.WritableBaseInfo openWritableBase = this.myContext.openWritableBase(localAbspath, false, true);
            OutputStream newPristineStream = openWritableBase.stream;
            newPristineTmpAbspath = openWritableBase.tempBaseAbspath;
            localSha1ChecksumStream = openWritableBase.sha1ChecksumStream;
            localStream = new CopyingStream(newPristineStream, localStream);
            File baseFile = null;
            if (!fulltext) {
                SVNWCContext.PristineContentsInfo pristineContents = this.myContext.getPristineContents(localAbspath, true, true);
                baseFile = pristineContents.path;
                baseStream = pristineContents.stream;
                if (baseStream == null) {
                    baseStream = SVNFileUtil.DUMMY_IN;
                }
                if ((expectedMd5Checksum = this.myContext.getDb().readInfo((File)localAbspath, (ISVNWCDb.WCDbInfo.InfoField[])new ISVNWCDb.WCDbInfo.InfoField[]{ISVNWCDb.WCDbInfo.InfoField.checksum}).checksum) != null && expectedMd5Checksum.getKind() != SvnChecksum.Kind.md5) {
                    expectedMd5Checksum = this.myContext.getDb().getPristineMD5(localAbspath, expectedMd5Checksum);
                }
                if (expectedMd5Checksum != null) {
                    verifyChecksumStream = new SVNChecksumInputStream(baseStream, "MD5");
                    baseStream = verifyChecksumStream;
                } else {
                    expectedMd5Checksum = new SvnChecksum(SvnChecksum.Kind.md5, SVNFileUtil.computeChecksum(baseFile));
                }
            }
            editor.applyTextDelta(path, expectedMd5Checksum != null ? expectedMd5Checksum.getDigest() : null);
            if (this.myDeltaGenerator == null) {
                this.myDeltaGenerator = new SVNDeltaGenerator();
            }
            localMd5Checksum = new SvnChecksum(SvnChecksum.Kind.md5, this.myDeltaGenerator.sendDelta(path, baseStream, 0L, localStream, editor, true));
            if (verifyChecksumStream != null) {
                this.readRemainingStream(verifyChecksumStream, baseFile);
                verifyChecksum = new SvnChecksum(SvnChecksum.Kind.md5, verifyChecksumStream.getDigest());
            }
        }
        catch (SVNException svne) {
            error = svne.getErrorMessage().wrap("While preparing ''{0}'' for commit", localAbspath);
        }
        finally {
            SVNFileUtil.closeFile(localStream);
            SVNFileUtil.closeFile(baseStream);
        }
        if (expectedMd5Checksum != null && verifyChecksum != null && !expectedMd5Checksum.equals(verifyChecksum)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", localAbspath, expectedMd5Checksum.getDigest(), verifyChecksum.getDigest());
            SVNErrorMessage corruptedBaseErr = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE);
            SVNErrorManager.error(corruptedBaseErr, err, SVNLogType.WC);
        }
        if (error != null) {
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        try {
            editor.closeFile(path, localMd5Checksum != null ? localMd5Checksum.getDigest() : null);
        }
        catch (SVNException e) {
            this.fixError(localAbspath, path, e, SVNNodeKind.FILE);
        }
        SvnChecksum localSha1Checksum = new SvnChecksum(SvnChecksum.Kind.sha1, localSha1ChecksumStream.getDigest());
        this.myContext.getDb().installPristine(newPristineTmpAbspath, localSha1Checksum, localMd5Checksum);
        TransmittedChecksums result = new TransmittedChecksums();
        result.md5Checksum = localMd5Checksum;
        result.sha1Checksum = localSha1Checksum;
        return result;
    }

    private void readRemainingStream(SVNChecksumInputStream verifyChecksumStream, File sourceFile) throws SVNException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        do {
            try {
                bytesRead = verifyChecksumStream.read(buffer);
            }
            catch (IOException e) {
                SVNErrorMessage err = sourceFile != null ? SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from file ''{0}'': {1}", sourceFile, e.getMessage()) : SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Cannot read from stream: {0}", sourceFile, e.getMessage());
                SVNErrorManager.error(err, Level.FINE, SVNLogType.WC);
                return;
            }
        } while (bytesRead >= 0);
    }

    private static class TransmittedChecksums {
        public SvnChecksum md5Checksum;
        public SvnChecksum sha1Checksum;

        private TransmittedChecksums() {
        }
    }

    private class CopyingStream
    extends FilterInputStream {
        private OutputStream myOutput;

        public CopyingStream(OutputStream out, InputStream in) {
            super(in);
            this.myOutput = out;
        }

        @Override
        public int read() throws IOException {
            int r = super.read();
            if (r != -1) {
                this.myOutput.write(r);
            }
            return r;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int r = super.read(b);
            if (r != -1) {
                this.myOutput.write(b, 0, r);
            }
            return r;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int r = super.read(b, off, len);
            if (r != -1) {
                this.myOutput.write(b, off, r);
            }
            return r;
        }

        @Override
        public void close() throws IOException {
            try {
                this.myOutput.close();
            }
            finally {
                super.close();
            }
        }
    }
}

