/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.StringTokenizer;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPAuthentication;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

class HTTPDigestAuthentication
extends HTTPAuthentication {
    private static final char[] HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private String myCnonce;
    private String myQop;
    private String myLastNonce;
    private int myNC = 0;
    private String myCharset;

    protected HTTPDigestAuthentication(String charset) {
        this.myCharset = charset;
    }

    public void init() throws SVNException {
        String qop = this.getChallengeParameter("qop");
        String selectedQop = null;
        if (qop != null) {
            StringTokenizer tok = new StringTokenizer(qop, ",");
            while (tok.hasMoreTokens() && !"auth".equals(selectedQop = tok.nextToken().trim())) {
            }
        }
        if (selectedQop != null && !"auth".equals(selectedQop)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Digest HTTP auth: ''(0}'' is not supported", selectedQop);
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        this.myQop = selectedQop;
        this.myCnonce = this.createCnonce();
    }

    @Override
    public String authenticate() throws SVNException {
        if (this.getUserName() == null || this.getPassword() == null) {
            return null;
        }
        String uname = this.getUserName();
        String nonce = this.getParameter("nonce");
        if (nonce == null || !nonce.equals(this.myLastNonce)) {
            this.myNC = 0;
        }
        ++this.myNC;
        this.myLastNonce = nonce;
        String digest = this.createDigest(uname, this.getPassword(), this.myCharset);
        String uri = this.getParameter("uri");
        String realm = this.getParameter("realm");
        String opaque = this.getParameter("opaque");
        String algorithm = this.getParameter("algorithm", "MD5");
        StringBuffer sb = new StringBuffer();
        sb.append("Digest ");
        sb.append("username=\"" + uname + "\"").append(", realm=\"" + realm + "\"").append(", nonce=\"" + nonce + "\"").append(", uri=\"" + uri + "\"").append(", response=\"" + digest + "\"");
        String nc = HTTPDigestAuthentication.formatNC(this.myNC);
        if (this.myQop != null) {
            sb.append(", qop=\"" + this.myQop + "\"").append(", nc=" + nc).append(", cnonce=\"" + this.myCnonce + "\"");
        }
        if (algorithm != null) {
            sb.append(", algorithm=\"" + algorithm + "\"");
        }
        if (opaque != null) {
            sb.append(", opaque=\"" + opaque + "\"");
        }
        return sb.toString();
    }

    @Override
    public String getAuthenticationScheme() {
        return "Digest";
    }

    private String createDigest(String uname, char[] pwd, String charset) throws SVNException {
        StringBuffer tmp2;
        MessageDigest md5Helper;
        String digAlg = "MD5";
        String uri = this.getParameter("uri");
        String realm = this.getParameter("realm");
        String nonce = this.getParameter("nonce");
        String method = this.getParameter("method");
        String algorithm = this.getParameter("algorithm", "MD5");
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "Unsupported algorithm in HTTP Digest authentication: ''{0}''", (Object)"MD5");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
            return null;
        }
        char[] tmp = new char[uname.length() + realm.length() + pwd.length + 2];
        System.arraycopy(uname.toCharArray(), 0, tmp, 0, uname.length());
        tmp[uname.length()] = 58;
        System.arraycopy(realm.toCharArray(), 0, tmp, uname.length() + 1, realm.length());
        tmp[uname.length() + realm.length() + 1] = 58;
        System.arraycopy(pwd, 0, tmp, uname.length() + realm.length() + 2, pwd.length);
        char[] a1 = tmp;
        if ("MD5-sess".equals(algorithm)) {
            String tmp22 = HTTPDigestAuthentication.encode(md5Helper.digest(HTTPAuthentication.getBytes(tmp, charset)));
            StringBuffer tmp3 = new StringBuffer(tmp22.length() + nonce.length() + this.myCnonce.length() + 2);
            tmp3.append(tmp22);
            tmp3.append(':');
            tmp3.append(nonce);
            tmp3.append(':');
            tmp3.append(this.myCnonce);
            a1 = tmp3.toString().toCharArray();
        }
        String md5a1 = HTTPDigestAuthentication.encode(md5Helper.digest(HTTPAuthentication.getBytes(a1, charset)));
        String a2 = method + ":" + uri;
        String md5a2 = HTTPDigestAuthentication.encode(md5Helper.digest(HTTPAuthentication.getBytes(a2, charset)));
        HTTPAuthentication.clear(tmp);
        if (this.myQop == null) {
            tmp2 = new StringBuffer(md5a1.length() + nonce.length() + md5a2.length());
            tmp2.append(md5a1);
            tmp2.append(':');
            tmp2.append(nonce);
            tmp2.append(':');
            tmp2.append(md5a2);
        } else {
            String qopOption = "auth";
            String nc = HTTPDigestAuthentication.formatNC(this.myNC);
            tmp2 = new StringBuffer(md5a1.length() + nonce.length() + nc.length() + this.myCnonce.length() + qopOption.length() + md5a2.length() + 5);
            tmp2.append(md5a1);
            tmp2.append(':');
            tmp2.append(nonce);
            tmp2.append(':');
            tmp2.append(nc);
            tmp2.append(':');
            tmp2.append(this.myCnonce);
            tmp2.append(':');
            tmp2.append(qopOption);
            tmp2.append(':');
            tmp2.append(md5a2);
        }
        return HTTPDigestAuthentication.encode(md5Helper.digest(HTTPAuthentication.getBytes(tmp2.toString(), charset)));
    }

    private String getParameter(String name) {
        return this.getParameter(name, null);
    }

    private String getParameter(String name, String defaultValue) {
        String value = this.getChallengeParameter(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    private String createCnonce() {
        MessageDigest md5Helper;
        String digAlg = "MD5";
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            return null;
        }
        String cnonce = Long.toString(System.currentTimeMillis());
        cnonce = HTTPDigestAuthentication.encode(md5Helper.digest(HTTPAuthentication.getBytes(cnonce, this.myCharset)));
        return cnonce;
    }

    private static String encode(byte[] binaryData) {
        if (binaryData.length != 16) {
            return null;
        }
        char[] buffer = new char[32];
        for (int i = 0; i < 16; ++i) {
            int low = binaryData[i] & 0xF;
            int high = (binaryData[i] & 0xF0) >> 4;
            buffer[i * 2] = HEXADECIMAL[high];
            buffer[i * 2 + 1] = HEXADECIMAL[low];
        }
        return new String(buffer);
    }

    private static String formatNC(int nc) {
        Object value = Integer.toHexString(nc);
        int count = 8 - ((String)value).length();
        for (int i = 0; i < count; ++i) {
            value = "0" + (String)value;
        }
        return value;
    }
}

