/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.handlers;

import java.util.HashMap;
import java.util.Map;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.handlers.BasicDAVHandler;
import org.tmatesoft.svn.core.internal.util.SVNXMLUtil;
import org.xml.sax.Attributes;

public class DAVInheritedPropertiesHandler
extends BasicDAVHandler {
    private Map<String, SVNProperties> inhertiedProperties;
    private String currentValueEncoding;
    private String currentPropertyName;
    private SVNPropertyValue currentPropertyValue;
    private SVNProperties currentProperties;
    private static final DAVElement IPROPNAME = DAVElement.getElement("svn:", "iprop-propname");
    private static final DAVElement IPROPVALUE = DAVElement.getElement("svn:", "iprop-propval");
    private static final DAVElement IPROPITEM = DAVElement.getElement("svn:", "iprop-item");
    private static final DAVElement IPROPPATH = DAVElement.getElement("svn:", "iprop-path");

    public static StringBuffer generateReport(StringBuffer xmlBuffer, String path, long revision) {
        xmlBuffer = xmlBuffer == null ? new StringBuffer() : xmlBuffer;
        SVNXMLUtil.addXMLHeader(xmlBuffer);
        SVNXMLUtil.openNamespaceDeclarationTag("S", "inherited-props-report", SVN_DAV_NAMESPACES_LIST, SVNXMLUtil.PREFIX_MAP, xmlBuffer);
        SVNXMLUtil.openCDataTag("S", "revision", String.valueOf(revision), xmlBuffer);
        SVNXMLUtil.openCDataTag("S", "path", path, xmlBuffer);
        SVNXMLUtil.closeXMLTag("S", "inherited-props-report", xmlBuffer);
        return xmlBuffer;
    }

    public DAVInheritedPropertiesHandler() {
        this.init();
        this.inhertiedProperties = new HashMap<String, SVNProperties>();
    }

    @Override
    protected void startElement(DAVElement parent, DAVElement element, Attributes attrs) throws SVNException {
        if (element == IPROPVALUE) {
            this.currentValueEncoding = attrs.getValue("encoding");
        } else if (element == IPROPITEM) {
            this.currentProperties = new SVNProperties();
            this.currentPropertyName = null;
            this.currentPropertyValue = null;
        }
    }

    @Override
    protected void endElement(DAVElement parent, DAVElement element, StringBuffer cdata) throws SVNException {
        if (element == IPROPNAME) {
            this.currentPropertyName = cdata.toString();
        } else if (element == IPROPVALUE) {
            this.currentPropertyValue = this.createPropertyValue(element, this.currentPropertyName, cdata, this.currentValueEncoding);
            this.currentProperties.put(this.currentPropertyName, this.currentPropertyValue);
            this.currentValueEncoding = null;
            this.currentPropertyName = null;
            this.currentPropertyValue = null;
        } else if (element == IPROPITEM) {
            this.currentPropertyName = null;
            this.currentPropertyValue = null;
        } else if (element == IPROPPATH) {
            Object repositoryPath = cdata.toString();
            if (!((String)repositoryPath).startsWith("/")) {
                repositoryPath = "/" + (String)repositoryPath;
            }
            this.inhertiedProperties.put((String)repositoryPath, this.currentProperties);
        }
    }

    public Map<String, SVNProperties> getInheritedProperties() {
        return this.inhertiedProperties;
    }
}

