/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNPropertiesCommand;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.wc.ISVNPropertyHandler;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNPropEditCommand
extends SVNPropertiesCommand {
    public SVNPropEditCommand() {
        super("propedit", new String[]{"pedit", "pe"});
    }

    @Override
    protected Collection createSupportedOptions() {
        Collection<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.REVISION);
        options.add(SVNOption.REVPROP);
        options = SVNOption.addLogMessageOptions(options);
        options.add(SVNOption.FORCE);
        return options;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() throws SVNException {
        SVNErrorMessage err;
        String propertyName = this.getSVNEnvironment().popArgument();
        if (propertyName == null) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (!SVNPropertiesManager.isValidPropertyName(propertyName)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is not a valid Subversion property name", (Object)propertyName);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        List<Object> targets = new ArrayList();
        targets = this.getSVNEnvironment().combineTargets(targets, true);
        if (this.getSVNEnvironment().isRevprop()) {
            long rev;
            if (targets.isEmpty()) {
                targets.add("");
            }
            SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
            String target = this.checkRevPropTarget(this.getSVNEnvironment().getStartRevision(), targets);
            SVNURL revPropURL = null;
            Object var6_10 = null;
            if (SVNCommandUtil.isURL(target)) {
                revPropURL = SVNURL.parseURIEncoded(target);
                rev = client.doGetRevisionProperty(revPropURL, propertyName, this.getSVNEnvironment().getStartRevision(), (ISVNPropertyHandler)this);
            } else {
                File file = new SVNPath(target).getFile();
                rev = client.doGetRevisionProperty(file, propertyName, this.getSVNEnvironment().getStartRevision(), (ISVNPropertyHandler)this);
            }
            SVNPropertyData property = this.getRevisionProperty(rev);
            SVNPropertyValue propertyValue = property != null ? property.getValue() : SVNPropertyValue.create("");
            byte[] propBytes = SVNPropertyValue.getPropertyAsBytes(propertyValue);
            byte[] bytes = SVNCommandUtil.runEditor(this.getSVNEnvironment(), this.getSVNEnvironment().getEditorCommand(), propBytes, "svn-prop");
            SVNPropertyValue newPropertyValue = SVNPropertyValue.create(propertyName, bytes);
            if (newPropertyValue != null && !newPropertyValue.equals(propertyValue)) {
                void var6_12;
                this.clearCollectedProperties();
                if (revPropURL != null) {
                    client.doSetRevisionProperty(revPropURL, SVNRevision.create(rev), propertyName, newPropertyValue, this.getSVNEnvironment().isForce(), (ISVNPropertyHandler)this);
                } else if (var6_12 != null) {
                    client.doSetRevisionProperty((File)var6_12, SVNRevision.create(rev), propertyName, newPropertyValue, this.getSVNEnvironment().isForce(), (ISVNPropertyHandler)this);
                }
                String message = "Set new value for property ''{0}'' on revision {1}";
                message = MessageFormat.format(message, propertyName, rev);
                this.getSVNEnvironment().getOut().println(message);
            } else {
                String message = "No changes to property ''{0}'' on revision {1}";
                message = MessageFormat.format(message, propertyName, rev);
                this.getSVNEnvironment().getOut().println(message);
            }
        } else if (this.getSVNEnvironment().getStartRevision() != SVNRevision.UNDEFINED) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Cannot specify revision for editing versioned property ''{0}''", (Object)propertyName);
            SVNErrorManager.error(err2, SVNLogType.CLIENT);
        } else {
            if (targets.isEmpty()) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Explicit target argument required", (Object)propertyName);
                SVNErrorManager.error(err3, SVNLogType.CLIENT);
            }
            SVNWCClient client = this.getSVNEnvironment().getClientManager().getWCClient();
            SVNNotifyPrinter printer = new SVNNotifyPrinter(this.getSVNEnvironment());
            client.setEventHandler(printer);
            for (String string : targets) {
                SVNPath target = new SVNPath(string);
                if (target.isFile()) {
                    if (this.getSVNEnvironment().getMessage() != null || this.getSVNEnvironment().getFileData() != null || this.getSVNEnvironment().getRevisionProperties() != null) {
                        SVNErrorMessage err4 = SVNErrorMessage.create(SVNErrorCode.CL_UNNECESSARY_LOG_MESSAGE, "Local, non-commit operations do not take a log message or revision properties");
                        SVNErrorManager.error(err4, SVNLogType.CLIENT);
                    }
                    propertyValue = (property = client.doGetProperty(target.getFile(), propertyName, SVNRevision.UNDEFINED, SVNRevision.WORKING)) != null ? property.getValue() : SVNPropertyValue.create("");
                    propBytes = SVNPropertyValue.getPropertyAsBytes(propertyValue);
                    bytes = SVNCommandUtil.runEditor(this.getSVNEnvironment(), this.getSVNEnvironment().getEditorCommand(), propBytes, "svn-prop");
                    newPropertyValue = SVNPropertyValue.create(propertyName, bytes);
                    if (newPropertyValue != null && !newPropertyValue.equals(propertyValue)) {
                        this.checkBooleanProperty(propertyName, newPropertyValue);
                        client.doSetProperty(target.getFile(), propertyName, newPropertyValue, this.getSVNEnvironment().isForce(), SVNDepth.EMPTY, this, null);
                        message = "Set new value for property ''{0}'' on ''{1}''";
                        path = SVNCommandUtil.getLocalPath(string);
                        message = MessageFormat.format(message, propertyName, path);
                        this.getSVNEnvironment().getOut().println(message);
                    } else {
                        message = "No changes to property ''{0}'' on ''{1}''";
                        path = SVNCommandUtil.getLocalPath(string);
                        message = MessageFormat.format(message, propertyName, path);
                        this.getSVNEnvironment().getOut().println(message);
                    }
                } else {
                    property = client.doGetProperty(target.getURL(), propertyName, SVNRevision.UNDEFINED, SVNRevision.HEAD);
                    propertyValue = property != null ? property.getValue() : SVNPropertyValue.create("");
                    propBytes = SVNPropertyValue.getPropertyAsBytes(propertyValue);
                    bytes = SVNCommandUtil.runEditor(this.getSVNEnvironment(), this.getSVNEnvironment().getEditorCommand(), propBytes, "svn-prop");
                    newPropertyValue = SVNPropertyValue.create(propertyName, bytes);
                    if (newPropertyValue != null && !newPropertyValue.equals(propertyValue)) {
                        this.checkBooleanProperty(propertyName, newPropertyValue);
                        client.setCommitHandler(this.getSVNEnvironment());
                        SVNCommitInfo info = client.doSetProperty(target.getURL(), propertyName, newPropertyValue, SVNRevision.HEAD, this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties(), this.getSVNEnvironment().isForce(), this);
                        String message = "Set new value for property ''{0}'' on ''{1}''";
                        message = MessageFormat.format(message, propertyName, string);
                        this.getSVNEnvironment().getOut().println(message);
                        if (!this.getSVNEnvironment().isQuiet()) {
                            this.getSVNEnvironment().printCommitInfo(info);
                        }
                    } else {
                        message = "No changes to property ''{0}'' on ''{1}''";
                        message = MessageFormat.format(message, propertyName, string);
                        this.getSVNEnvironment().getOut().println(message);
                    }
                }
                this.clearCollectedProperties();
            }
        }
    }
}

