/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMkDirCommand
extends SVNCommand {
    public SVNMkDirCommand() {
        super("mkdir", null);
    }

    @Override
    public boolean isCommitter() {
        return true;
    }

    @Override
    protected Collection createSupportedOptions() {
        Collection<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.QUIET);
        options.add(SVNOption.PARENTS);
        options = SVNOption.addLogMessageOptions(options);
        return options;
    }

    @Override
    public void run() throws SVNException {
        List<String> targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        if (targets.isEmpty()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS), SVNLogType.CLIENT);
        }
        boolean hasURLs = false;
        boolean hasPaths = false;
        for (String targetName : targets) {
            if (!SVNCommandUtil.isURL(targetName)) {
                hasPaths = true;
                continue;
            }
            hasURLs = true;
        }
        if (hasURLs && hasPaths) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot mix repository and working copy targets"), SVNLogType.CLIENT);
        }
        if (hasPaths && (this.getSVNEnvironment().getMessage() != null || this.getSVNEnvironment().getFileData() != null || this.getSVNEnvironment().getRevisionProperties() != null)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_UNNECESSARY_LOG_MESSAGE, "Local, non-commit operations do not take a log message or revision properties");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (hasURLs) {
            client = this.getSVNEnvironment().getClientManager().getCommitClient();
            if (!this.getSVNEnvironment().isQuiet()) {
                client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
            }
            ((SVNCommitClient)client).setCommitHandler(this.getSVNEnvironment());
            SVNURL[] urls = new SVNURL[targets.size()];
            for (int i = 0; i < targets.size(); ++i) {
                String url = targets.get(i);
                urls[i] = SVNURL.parseURIEncoded(url);
            }
            try {
                SVNCommitInfo info = ((SVNCommitClient)client).doMkDir(urls, this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties(), this.getSVNEnvironment().isParents());
                if (!this.getSVNEnvironment().isQuiet()) {
                    this.getSVNEnvironment().printCommitInfo(info);
                }
            }
            catch (SVNException e) {
                SVNErrorMessage err = e.getErrorMessage();
                if (!(this.getSVNEnvironment().isParents() || err.getErrorCode() != SVNErrorCode.FS_NOT_FOUND && err.getErrorCode() != SVNErrorCode.FS_NOT_DIRECTORY && err.getErrorCode() != SVNErrorCode.RA_DAV_PATH_NOT_FOUND)) {
                    err = err.wrap("Try 'svn mkdir --parents' instead?");
                }
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
        } else {
            client = this.getSVNEnvironment().getClientManager().getWCClient();
            if (!this.getSVNEnvironment().isQuiet()) {
                client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
            }
            try {
                for (String targetName : targets) {
                    SVNPath target = new SVNPath(targetName);
                    ((SVNWCClient)client).doAdd(target.getFile(), false, true, false, SVNDepth.EMPTY, false, this.getSVNEnvironment().isParents());
                }
            }
            catch (SVNException e) {
                SVNErrorMessage err = e.getErrorMessage();
                if (err.getErrorCode() == SVNErrorCode.IO_ERROR) {
                    err = err.wrap("Try 'svn add' or 'svn add --non-recursive' instead?");
                } else if (!(this.getSVNEnvironment().isParents() || err.getErrorCode() != SVNErrorCode.IO_ERROR && err.getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND && err.getErrorCode() != SVNErrorCode.FS_NOT_DIRECTORY && err.getErrorCode() != SVNErrorCode.FS_NOT_FOUND && err.getErrorCode() != SVNErrorCode.ENTRY_NOT_FOUND)) {
                    err = err.wrap("Try 'svn mkdir --parents' instead?");
                }
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
        }
    }
}

