/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNNotifyPrinter;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNPath;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDeleteCommand
extends SVNCommand {
    public SVNDeleteCommand() {
        super("delete", new String[]{"del", "remove", "rm"});
    }

    @Override
    public boolean isCommitter() {
        return true;
    }

    @Override
    protected Collection createSupportedOptions() {
        Collection<SVNOption> options = new LinkedList<SVNOption>();
        options.add(SVNOption.FORCE);
        options.add(SVNOption.QUIET);
        options.add(SVNOption.TARGETS);
        options = SVNOption.addLogMessageOptions(options);
        options.add(SVNOption.KEEP_LOCAL);
        return options;
    }

    @Override
    public void run() throws SVNException {
        SVNErrorMessage err;
        List<String> targets = this.getSVNEnvironment().combineTargets(this.getSVNEnvironment().getTargets(), true);
        if (targets.isEmpty()) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS), SVNLogType.CLIENT);
        }
        boolean hasURLs = false;
        boolean hasPaths = false;
        for (String targetName : targets) {
            if (!SVNCommandUtil.isURL(targetName)) {
                if (this.getSVNEnvironment().getMessage() != null || this.getSVNEnvironment().getFileData() != null || this.getSVNEnvironment().getRevisionProperties() != null) {
                    err = SVNErrorMessage.create(SVNErrorCode.CL_UNNECESSARY_LOG_MESSAGE, "Local, non-commit operations do not take a log message or revision properties");
                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                }
                hasPaths = true;
                continue;
            }
            hasURLs = true;
        }
        if (hasURLs && hasPaths) {
            SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Specify either URLs or local paths, not both"), SVNLogType.CLIENT);
        }
        if (hasURLs) {
            client = this.getSVNEnvironment().getClientManager().getCommitClient();
            if (!this.getSVNEnvironment().isQuiet()) {
                client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
            }
            ((SVNCommitClient)client).setCommitHandler(this.getSVNEnvironment());
            SVNURL[] urls = new SVNURL[targets.size()];
            for (int i = 0; i < targets.size(); ++i) {
                String url = targets.get(i);
                urls[i] = SVNURL.parseURIEncoded(url);
            }
            try {
                SVNCommitInfo info = ((SVNCommitClient)client).doDelete(urls, this.getSVNEnvironment().getMessage(), this.getSVNEnvironment().getRevisionProperties());
                if (!this.getSVNEnvironment().isQuiet()) {
                    this.getSVNEnvironment().printCommitInfo(info);
                }
            }
            catch (SVNException e) {
                SVNErrorMessage err2 = e.getErrorMessage();
                SVNErrorManager.error(err2, SVNLogType.CLIENT);
            }
        } else {
            client = this.getSVNEnvironment().getClientManager().getWCClient();
            if (!this.getSVNEnvironment().isQuiet()) {
                client.setEventHandler(new SVNNotifyPrinter(this.getSVNEnvironment()));
            }
            try {
                for (String targetName : targets) {
                    SVNPath target = new SVNPath(targetName);
                    ((SVNWCClient)client).doDelete(target.getFile(), this.getSVNEnvironment().isForce(), !this.getSVNEnvironment().isKeepLocal(), false);
                }
            }
            catch (SVNException e) {
                SVNErrorCode code;
                err = e.getErrorMessage();
                if (err != null && ((code = err.getErrorCode()) == SVNErrorCode.UNVERSIONED_RESOURCE || code == SVNErrorCode.CLIENT_MODIFIED)) {
                    err = err.wrap("Use --force to override this restriction");
                }
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
        }
    }
}

