/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.cli.svn;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.tmatesoft.svn.cli.AbstractSVNCommand;
import org.tmatesoft.svn.cli.AbstractSVNCommandEnvironment;
import org.tmatesoft.svn.cli.AbstractSVNOption;
import org.tmatesoft.svn.cli.SVNCommandLine;
import org.tmatesoft.svn.cli.SVNCommandUtil;
import org.tmatesoft.svn.cli.SVNConsoleAuthenticationProvider;
import org.tmatesoft.svn.cli.SVNOptionValue;
import org.tmatesoft.svn.cli.svn.SVNAddCommand;
import org.tmatesoft.svn.cli.svn.SVNCommand;
import org.tmatesoft.svn.cli.svn.SVNCommandLineConflictHandler;
import org.tmatesoft.svn.cli.svn.SVNCommitCommand;
import org.tmatesoft.svn.cli.svn.SVNConflictAcceptPolicy;
import org.tmatesoft.svn.cli.svn.SVNLogCommand;
import org.tmatesoft.svn.cli.svn.SVNMergeCommand;
import org.tmatesoft.svn.cli.svn.SVNOption;
import org.tmatesoft.svn.cli.svn.SVNRevertCommand;
import org.tmatesoft.svn.cli.svn.SVNShowRevisionType;
import org.tmatesoft.svn.cli.svn.SVNStatusCommand;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNCertificateFailureKind;
import org.tmatesoft.svn.core.internal.util.SVNHashSet;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthStoreHandler;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorageOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNGnomeKeyringPasswordProvider;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNPropertiesManager;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.wc.ISVNCommitHandler;
import org.tmatesoft.svn.core.wc.SVNCommitItem;
import org.tmatesoft.svn.core.wc.SVNConflictStats;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNCommandEnvironment
extends AbstractSVNCommandEnvironment
implements ISVNCommitHandler {
    private static final String DEFAULT_LOG_MESSAGE_HEADER = "--This line, and those below, will be ignored--";
    private SVNDepth myDepth;
    private SVNDepth mySetDepth;
    private boolean myIsVerbose;
    private boolean myIsUpdate;
    private boolean myIsQuiet;
    private boolean myIsIncremental;
    private boolean myIsHelp;
    private boolean myIsIgnoreExternals;
    private boolean myIsIgnoreKeywords;
    private boolean myIsXML;
    private boolean myIsVersion;
    private String myChangelist;
    private boolean myIsNonInteractive;
    private boolean myIsForceInteractive;
    private boolean myIsNoAuthCache;
    private String myUserName;
    private String myPassword;
    private String myConfigDir;
    private boolean myIsDescend = true;
    private boolean myIsNoIgnore;
    private boolean myIsRevprop;
    private boolean myIsStrict;
    private SVNRevision myStartRevision;
    private SVNRevision myEndRevision;
    private boolean myIsForce;
    private String myFilePath;
    private byte[] myFileData;
    private List myTargets;
    private String myEncoding;
    private String myMessage;
    private boolean myIsForceLog;
    private String myEditorCommand;
    private String myDiffCommand;
    private SVNProperties myRevisionProperties;
    private boolean myIsNoUnlock;
    private boolean myIsDryRun;
    private boolean myIsRecordOnly;
    private boolean myIsUseMergeHistory;
    private Collection myExtensions;
    private boolean myIsIgnoreAncestry;
    private boolean myIsShowCopiesAsAdds;
    private String myNativeEOL;
    private boolean myIsRelocate;
    private boolean myIsNoAutoProps;
    private boolean myIsAutoProps;
    private boolean myIsKeepChangelist;
    private boolean myIsParents;
    private boolean myIsKeepLocal;
    private SVNConflictAcceptPolicy myResolveAccept = SVNConflictAcceptPolicy.UNSPECIFIED;
    private boolean myIsRemove;
    private String myNewTarget;
    private String myOldTarget;
    private boolean myIsNoticeAncestry;
    private boolean myIsSummarize;
    private boolean myIsNoDiffDeleted;
    private boolean myIsNoDiffAdded;
    private long myLimit = -1L;
    private boolean myIsStopOnCopy;
    private boolean myIsChangeOptionUsed;
    private boolean myIsRevisionOptionUsed;
    private boolean myIsWithAllRevprops;
    private boolean myIsReIntegrate;
    private boolean myIsTrustServerCertificate;
    private EnumSet<SVNCertificateFailureKind> myIsTrustServerCertificateFailures;
    private boolean myIsAllowMixedRevisions;
    private List myRevisionRanges;
    private SVNShowRevisionType myShowRevsType;
    private Collection myChangelists;
    private String myAuthorOfInterest;
    private String myRegularExpression;
    private Map myConfigOptions;
    private Map myServersOptions;
    private boolean myIsGitDiffFormat;
    private boolean myIsShowDiff;
    private boolean myIsPropertiesOnly;
    private boolean myIsIgnoreProperties;
    private boolean myIsReverseDiff;
    private boolean myIsIgnoreWhitespace;
    private int myStripCount;
    private boolean myIsShowInhertiedProps;
    private boolean myIsIncludeExternals;
    private String myShowItem;
    private boolean myIsNoNewLine;
    private boolean myIsPinExternals;
    private boolean myIsRemoveUnversioned;
    private boolean myIsRemoveIgnored;
    private SVNConflictStats myConflictStats;

    public SVNCommandEnvironment(String programName, PrintStream out, PrintStream err, InputStream in) {
        super(programName, out, err, in);
        this.myDepth = SVNDepth.UNKNOWN;
        this.mySetDepth = SVNDepth.UNKNOWN;
        this.myStartRevision = SVNRevision.UNDEFINED;
        this.myEndRevision = SVNRevision.UNDEFINED;
        this.myShowRevsType = SVNShowRevisionType.MERGED;
        this.myRevisionRanges = new LinkedList();
        this.myChangelists = new SVNHashSet();
        this.myConflictStats = new SVNConflictStats();
    }

    @Override
    public void initClientManager() throws SVNException {
        super.initClientManager();
        this.getClientManager().setIgnoreExternals(this.myIsIgnoreExternals);
    }

    @Override
    protected String refineCommandName(String commandName, SVNCommandLine commandLine) throws SVNException {
        Iterator options = commandLine.optionValues();
        while (options.hasNext()) {
            SVNOptionValue optionValue = (SVNOptionValue)options.next();
            AbstractSVNOption option = optionValue.getOption();
            if (option == SVNOption.HELP || option == SVNOption.QUESTION) {
                this.myIsHelp = true;
                continue;
            }
            if (option != SVNOption.VERSION) continue;
            this.myIsVersion = true;
        }
        if (this.myIsHelp) {
            List<String> newArguments = commandName != null ? Collections.singletonList(commandName) : Collections.EMPTY_LIST;
            this.setArguments(newArguments);
            return "help";
        }
        if (commandName == null) {
            if (this.isVersion()) {
                SVNCommand versionCommand = new SVNCommand("--version", null){

                    @Override
                    protected Collection createSupportedOptions() {
                        LinkedList<SVNOption> options = new LinkedList<SVNOption>();
                        options.add(SVNOption.VERSION);
                        options.add(SVNOption.CONFIG_DIR);
                        options.add(SVNOption.QUIET);
                        return options;
                    }

                    @Override
                    public void run() throws SVNException {
                        AbstractSVNCommand helpCommand = AbstractSVNCommand.getCommand("help");
                        helpCommand.init(SVNCommandEnvironment.this);
                        helpCommand.run();
                    }
                };
                AbstractSVNCommand.registerCommand(versionCommand);
                return "--version";
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Subcommand argument required");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        return commandName;
    }

    @Override
    protected DefaultSVNOptions createClientOptions() throws SVNException {
        File configDir = this.myConfigDir != null ? new File(this.myConfigDir) : SVNWCUtil.getDefaultConfigurationDirectory();
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions(configDir, true);
        options.setAuthStorageEnabled(!this.myIsNoAuthCache);
        if (this.myIsAutoProps) {
            options.setUseAutoProperties(true);
        }
        if (this.myIsNoAutoProps) {
            options.setUseAutoProperties(false);
        }
        if (this.myIsNoUnlock) {
            options.setKeepLocks(true);
        }
        if (this.myResolveAccept == SVNConflictAcceptPolicy.UNSPECIFIED && (!options.isInteractiveConflictResolution() || this.myIsNonInteractive) || this.myResolveAccept == SVNConflictAcceptPolicy.POSTPONE) {
            options.setConflictHandler(null);
        } else {
            if (this.myIsNonInteractive) {
                SVNErrorMessage err;
                if (this.myResolveAccept == SVNConflictAcceptPolicy.EDIT) {
                    err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "--accept={0} incompatible with --non-interactive", (Object)SVNConflictAcceptPolicy.EDIT);
                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                }
                if (this.myResolveAccept == SVNConflictAcceptPolicy.LAUNCH) {
                    err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "--accept={0} incompatible with --non-interactive", (Object)SVNConflictAcceptPolicy.LAUNCH);
                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                }
            }
            options.setConflictHandler(new SVNCommandLineConflictHandler(this.myResolveAccept, this));
        }
        options.setInMemoryConfigOptions(this.myConfigOptions);
        return options;
    }

    @Override
    protected ISVNAuthenticationManager createClientAuthenticationManager() {
        SVNConsoleAuthenticationProvider gnomeKeyringPasswordProvider;
        SVNConsoleAuthenticationProvider authStoreHandler;
        File configDir = this.myConfigDir != null ? new File(this.myConfigDir) : SVNWCUtil.getDefaultConfigurationDirectory();
        final DefaultSVNAuthenticationManager authManager = (DefaultSVNAuthenticationManager)SVNWCUtil.createDefaultAuthenticationManager(configDir, this.myUserName, this.myPassword, !this.myIsNoAuthCache);
        if (!this.myIsNonInteractive) {
            SVNConsoleAuthenticationProvider consoleAuthProvider = new SVNConsoleAuthenticationProvider(this.myIsTrustServerCertificateFailures);
            authManager.setAuthenticationProvider(consoleAuthProvider);
            authStoreHandler = consoleAuthProvider;
            gnomeKeyringPasswordProvider = consoleAuthProvider;
        } else {
            authStoreHandler = null;
            gnomeKeyringPasswordProvider = null;
        }
        ISVNAuthenticationStorageOptions authOpts = new ISVNAuthenticationStorageOptions(){

            @Override
            public boolean isNonInteractive() throws SVNException {
                return SVNCommandEnvironment.this.myIsNonInteractive;
            }

            @Override
            public ISVNAuthStoreHandler getAuthStoreHandler() throws SVNException {
                return authStoreHandler;
            }

            @Override
            public boolean isSSLPassphrasePromptSupported() {
                return authManager.isSSLPassphrasePromtSupported();
            }

            @Override
            public ISVNGnomeKeyringPasswordProvider getGnomeKeyringPasswordProvider() {
                return gnomeKeyringPasswordProvider;
            }
        };
        authManager.setAuthenticationStorageOptions(authOpts);
        authManager.setInMemoryConfigOptions(this.myConfigOptions);
        authManager.setInMemoryServersOptions(this.myServersOptions);
        return authManager;
    }

    @Override
    protected void initOptions(SVNCommandLine commandLine) throws SVNException {
        SVNErrorMessage err;
        SVNRevisionRange range;
        super.initOptions(commandLine);
        if (this.myIsNonInteractive && this.myIsForceInteractive) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "--non-interactive and --force-interactive are mutually exclusive");
            SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
        } else if (this.myIsForceInteractive) {
            this.myIsNonInteractive = false;
        }
        if (this.getCommand().getClass() != SVNMergeCommand.class && this.getCommand().getClass() != SVNLogCommand.class) {
            if (this.myRevisionRanges.size() > 1) {
                err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Multiple revision argument encountered; can't specify -c twice, or both -c and -r");
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
        } else if (!this.myRevisionRanges.isEmpty() && this.myIsReIntegrate) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "-r and -c can't be used with --reintegrate");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (this.myRevisionRanges.isEmpty()) {
            range = new SVNRevisionRange(SVNRevision.UNDEFINED, SVNRevision.UNDEFINED);
            this.myRevisionRanges.add(range);
        }
        range = (SVNRevisionRange)this.myRevisionRanges.get(0);
        this.myStartRevision = range.getStartRevision();
        this.myEndRevision = range.getEndRevision();
        if (this.myIsReIntegrate) {
            if (this.myIsIgnoreAncestry) {
                if (this.myIsRecordOnly) {
                    err = SVNErrorMessage.create(SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, "--reintegrate cannot be used with --ignore-ancestry or --record-only");
                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                } else {
                    err = SVNErrorMessage.create(SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, "--reintegrate cannot be used with --ignore-ancestry");
                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                }
            } else if (this.myIsRecordOnly) {
                err = SVNErrorMessage.create(SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, "--reintegrate cannot be used with --record-only");
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
        }
        if (this.myIsTrustServerCertificate && !this.myIsNonInteractive) {
            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "--trust-server-cert requires --non-interactive");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (this.myIsTrustServerCertificateFailures != null && this.myIsTrustServerCertificateFailures.size() > 0 && !this.myIsNonInteractive) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "--trust-server-cert-failures requires --non-interactive");
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
    }

    @Override
    protected void initOption(SVNOptionValue optionValue) throws SVNException {
        block56: {
            AbstractSVNOption option;
            block135: {
                block134: {
                    block133: {
                        block132: {
                            block131: {
                                block130: {
                                    block129: {
                                        block128: {
                                            String[] failures;
                                            block127: {
                                                block126: {
                                                    block125: {
                                                        block124: {
                                                            block123: {
                                                                block122: {
                                                                    block121: {
                                                                        block120: {
                                                                            block119: {
                                                                                block118: {
                                                                                    block117: {
                                                                                        block116: {
                                                                                            block115: {
                                                                                                block114: {
                                                                                                    block113: {
                                                                                                        block112: {
                                                                                                            block111: {
                                                                                                                block110: {
                                                                                                                    block109: {
                                                                                                                        block108: {
                                                                                                                            block107: {
                                                                                                                                block106: {
                                                                                                                                    block105: {
                                                                                                                                        block104: {
                                                                                                                                            block103: {
                                                                                                                                                block102: {
                                                                                                                                                    block101: {
                                                                                                                                                        block100: {
                                                                                                                                                            block99: {
                                                                                                                                                                block98: {
                                                                                                                                                                    block97: {
                                                                                                                                                                        block96: {
                                                                                                                                                                            block95: {
                                                                                                                                                                                block94: {
                                                                                                                                                                                    block93: {
                                                                                                                                                                                        block92: {
                                                                                                                                                                                            block91: {
                                                                                                                                                                                                block90: {
                                                                                                                                                                                                    block89: {
                                                                                                                                                                                                        block88: {
                                                                                                                                                                                                            block87: {
                                                                                                                                                                                                                block86: {
                                                                                                                                                                                                                    block85: {
                                                                                                                                                                                                                        block84: {
                                                                                                                                                                                                                            block83: {
                                                                                                                                                                                                                                block82: {
                                                                                                                                                                                                                                    block81: {
                                                                                                                                                                                                                                        block80: {
                                                                                                                                                                                                                                            block79: {
                                                                                                                                                                                                                                                block78: {
                                                                                                                                                                                                                                                    block77: {
                                                                                                                                                                                                                                                        block76: {
                                                                                                                                                                                                                                                            block75: {
                                                                                                                                                                                                                                                                block74: {
                                                                                                                                                                                                                                                                    block73: {
                                                                                                                                                                                                                                                                        block72: {
                                                                                                                                                                                                                                                                            block71: {
                                                                                                                                                                                                                                                                                block70: {
                                                                                                                                                                                                                                                                                    block69: {
                                                                                                                                                                                                                                                                                        block68: {
                                                                                                                                                                                                                                                                                            block67: {
                                                                                                                                                                                                                                                                                                block66: {
                                                                                                                                                                                                                                                                                                    block65: {
                                                                                                                                                                                                                                                                                                        String fileName;
                                                                                                                                                                                                                                                                                                        block64: {
                                                                                                                                                                                                                                                                                                            block63: {
                                                                                                                                                                                                                                                                                                                block62: {
                                                                                                                                                                                                                                                                                                                    block61: {
                                                                                                                                                                                                                                                                                                                        block60: {
                                                                                                                                                                                                                                                                                                                            block59: {
                                                                                                                                                                                                                                                                                                                                block58: {
                                                                                                                                                                                                                                                                                                                                    block57: {
                                                                                                                                                                                                                                                                                                                                        block55: {
                                                                                                                                                                                                                                                                                                                                            option = optionValue.getOption();
                                                                                                                                                                                                                                                                                                                                            if (option != SVNOption.LIMIT) break block55;
                                                                                                                                                                                                                                                                                                                                            String limitStr = optionValue.getValue();
                                                                                                                                                                                                                                                                                                                                            try {
                                                                                                                                                                                                                                                                                                                                                long limit = Long.parseLong(limitStr);
                                                                                                                                                                                                                                                                                                                                                if (limit <= 0L) {
                                                                                                                                                                                                                                                                                                                                                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Argument to --limit must be positive");
                                                                                                                                                                                                                                                                                                                                                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                this.myLimit = limit;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            catch (NumberFormatException nfe) {
                                                                                                                                                                                                                                                                                                                                                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Non-numeric limit argument given");
                                                                                                                                                                                                                                                                                                                                                SVNErrorManager.error(err, SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            break block56;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        if (option != SVNOption.MESSAGE) break block57;
                                                                                                                                                                                                                                                                                                                                        this.myMessage = optionValue.getValue();
                                                                                                                                                                                                                                                                                                                                        break block56;
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    if (option != SVNOption.CHANGE) break block58;
                                                                                                                                                                                                                                                                                                                                    if (this.myOldTarget != null) {
                                                                                                                                                                                                                                                                                                                                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Can't specify -c with --old");
                                                                                                                                                                                                                                                                                                                                        SVNErrorManager.error(err, SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    String chValue = optionValue.getValue();
                                                                                                                                                                                                                                                                                                                                    StringTokenizer tokens = new StringTokenizer(chValue, ", \n\r\t");
                                                                                                                                                                                                                                                                                                                                    while (tokens.hasMoreTokens()) {
                                                                                                                                                                                                                                                                                                                                        SVNErrorMessage err;
                                                                                                                                                                                                                                                                                                                                        String token = tokens.nextToken();
                                                                                                                                                                                                                                                                                                                                        boolean isNegative = false;
                                                                                                                                                                                                                                                                                                                                        if (token.startsWith("-")) {
                                                                                                                                                                                                                                                                                                                                            token = token.substring(1);
                                                                                                                                                                                                                                                                                                                                            isNegative = true;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        while (token.startsWith("r")) {
                                                                                                                                                                                                                                                                                                                                            token = token.substring(1);
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        long change = 0L;
                                                                                                                                                                                                                                                                                                                                        long changeEnd = 0L;
                                                                                                                                                                                                                                                                                                                                        try {
                                                                                                                                                                                                                                                                                                                                            if (token.indexOf("-") > 0) {
                                                                                                                                                                                                                                                                                                                                                if (isNegative || token.startsWith("-")) {
                                                                                                                                                                                                                                                                                                                                                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Negative number in range ({0}) is not supported with -c", (Object)token);
                                                                                                                                                                                                                                                                                                                                                    SVNErrorManager.error(err2, SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                String firstPart = token.substring(0, token.indexOf("-"));
                                                                                                                                                                                                                                                                                                                                                String secondPart = token.substring(token.indexOf("-") + 1);
                                                                                                                                                                                                                                                                                                                                                change = Long.parseLong(firstPart);
                                                                                                                                                                                                                                                                                                                                                while (secondPart.startsWith("r")) {
                                                                                                                                                                                                                                                                                                                                                    secondPart = secondPart.substring(1);
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                changeEnd = Long.parseLong(secondPart);
                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                changeEnd = change = Long.parseLong(token);
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        catch (NumberFormatException nfe) {
                                                                                                                                                                                                                                                                                                                                            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Non-numeric change argument ({0}) given to -c", (Object)token);
                                                                                                                                                                                                                                                                                                                                            SVNErrorManager.error(err, SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        if (isNegative) {
                                                                                                                                                                                                                                                                                                                                            change = -change;
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        SVNRevisionRange range = null;
                                                                                                                                                                                                                                                                                                                                        if (change == 0L) {
                                                                                                                                                                                                                                                                                                                                            err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "There is no change 0");
                                                                                                                                                                                                                                                                                                                                            SVNErrorManager.error(err, SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                                                                                        } else if (change > 0L) {
                                                                                                                                                                                                                                                                                                                                            if (change <= changeEnd) {
                                                                                                                                                                                                                                                                                                                                                --change;
                                                                                                                                                                                                                                                                                                                                            } else {
                                                                                                                                                                                                                                                                                                                                                --changeEnd;
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                            range = new SVNRevisionRange(SVNRevision.create(change), SVNRevision.create(changeEnd));
                                                                                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                                                                                            change = -change;
                                                                                                                                                                                                                                                                                                                                            changeEnd = change - 1L;
                                                                                                                                                                                                                                                                                                                                            range = new SVNRevisionRange(SVNRevision.create(change), SVNRevision.create(changeEnd));
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                        this.myIsChangeOptionUsed = true;
                                                                                                                                                                                                                                                                                                                                        this.myRevisionRanges.add(range);
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                    break block56;
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                if (option != SVNOption.REVISION) break block59;
                                                                                                                                                                                                                                                                                                                                String revStr = optionValue.getValue();
                                                                                                                                                                                                                                                                                                                                SVNRevision[] revisions = this.parseRevision(revStr);
                                                                                                                                                                                                                                                                                                                                if (revisions == null) {
                                                                                                                                                                                                                                                                                                                                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Syntax error in revision argument ''{0}''", (Object)revStr);
                                                                                                                                                                                                                                                                                                                                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                SVNRevisionRange range = new SVNRevisionRange(revisions[0], revisions[1]);
                                                                                                                                                                                                                                                                                                                                this.myRevisionRanges.add(range);
                                                                                                                                                                                                                                                                                                                                this.myIsRevisionOptionUsed = true;
                                                                                                                                                                                                                                                                                                                                break block56;
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                            if (option != SVNOption.VERBOSE) break block60;
                                                                                                                                                                                                                                                                                                                            this.myIsVerbose = true;
                                                                                                                                                                                                                                                                                                                            break block56;
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                        if (option != SVNOption.UPDATE) break block61;
                                                                                                                                                                                                                                                                                                                        this.myIsUpdate = true;
                                                                                                                                                                                                                                                                                                                        break block56;
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                    if (option != SVNOption.HELP && option != SVNOption.QUESTION) break block62;
                                                                                                                                                                                                                                                                                                                    this.myIsHelp = true;
                                                                                                                                                                                                                                                                                                                    break block56;
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                if (option != SVNOption.QUIET) break block63;
                                                                                                                                                                                                                                                                                                                this.myIsQuiet = true;
                                                                                                                                                                                                                                                                                                                break block56;
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                            if (option != SVNOption.INCREMENTAL) break block64;
                                                                                                                                                                                                                                                                                                            this.myIsIncremental = true;
                                                                                                                                                                                                                                                                                                            break block56;
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                        if (option != SVNOption.FILE) break block65;
                                                                                                                                                                                                                                                                                                        this.myFilePath = fileName = optionValue.getValue();
                                                                                                                                                                                                                                                                                                        this.myFileData = this.readFromFile(new File(fileName));
                                                                                                                                                                                                                                                                                                        break block56;
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    if (option != SVNOption.TARGETS) break block66;
                                                                                                                                                                                                                                                                                                    String fileName = optionValue.getValue();
                                                                                                                                                                                                                                                                                                    byte[] data = this.readFromFile(new File(fileName));
                                                                                                                                                                                                                                                                                                    try {
                                                                                                                                                                                                                                                                                                        String[] targets = new String(data, "UTF-8").split("[\n\r]");
                                                                                                                                                                                                                                                                                                        this.myTargets = new LinkedList();
                                                                                                                                                                                                                                                                                                        for (int i = 0; i < targets.length; ++i) {
                                                                                                                                                                                                                                                                                                            if (targets[i].trim().length() <= 0) continue;
                                                                                                                                                                                                                                                                                                            this.myTargets.add(targets[i].trim());
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    catch (UnsupportedEncodingException e) {
                                                                                                                                                                                                                                                                                                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
                                                                                                                                                                                                                                                                                                        SVNErrorManager.error(err, SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                    break block56;
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                if (option != SVNOption.FORCE) break block67;
                                                                                                                                                                                                                                                                                                this.myIsForce = true;
                                                                                                                                                                                                                                                                                                break block56;
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                            if (option != SVNOption.FORCE_LOG) break block68;
                                                                                                                                                                                                                                                                                            this.myIsForceLog = true;
                                                                                                                                                                                                                                                                                            break block56;
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                        if (option != SVNOption.DRY_RUN) break block69;
                                                                                                                                                                                                                                                                                        this.myIsDryRun = true;
                                                                                                                                                                                                                                                                                        break block56;
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                    if (option != SVNOption.REVPROP) break block70;
                                                                                                                                                                                                                                                                                    this.myIsRevprop = true;
                                                                                                                                                                                                                                                                                    break block56;
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                if (option != SVNOption.RECURSIVE) break block71;
                                                                                                                                                                                                                                                                                this.myDepth = SVNDepth.fromRecurse(true);
                                                                                                                                                                                                                                                                                break block56;
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                            if (option != SVNOption.NON_RECURSIVE) break block72;
                                                                                                                                                                                                                                                                            this.myIsDescend = false;
                                                                                                                                                                                                                                                                            break block56;
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        if (option != SVNOption.DEPTH) break block73;
                                                                                                                                                                                                                                                                        String depth = optionValue.getValue();
                                                                                                                                                                                                                                                                        if (SVNDepth.EMPTY.getName().equals(depth)) {
                                                                                                                                                                                                                                                                            this.myDepth = SVNDepth.EMPTY;
                                                                                                                                                                                                                                                                        } else if (SVNDepth.FILES.getName().equals(depth)) {
                                                                                                                                                                                                                                                                            this.myDepth = SVNDepth.FILES;
                                                                                                                                                                                                                                                                        } else if (SVNDepth.IMMEDIATES.getName().equals(depth)) {
                                                                                                                                                                                                                                                                            this.myDepth = SVNDepth.IMMEDIATES;
                                                                                                                                                                                                                                                                        } else if (SVNDepth.INFINITY.getName().equals(depth)) {
                                                                                                                                                                                                                                                                            this.myDepth = SVNDepth.INFINITY;
                                                                                                                                                                                                                                                                        } else {
                                                                                                                                                                                                                                                                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "''{0}'' is not a valid depth; try ''empty'', ''files'', ''immediates'', or ''infinity''", (Object)depth);
                                                                                                                                                                                                                                                                            SVNErrorManager.error(err, SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                        break block56;
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    if (option != SVNOption.SET_DEPTH) break block74;
                                                                                                                                                                                                                                                                    String depth = optionValue.getValue();
                                                                                                                                                                                                                                                                    if (SVNDepth.EMPTY.getName().equals(depth)) {
                                                                                                                                                                                                                                                                        this.mySetDepth = SVNDepth.EMPTY;
                                                                                                                                                                                                                                                                    } else if (SVNDepth.FILES.getName().equals(depth)) {
                                                                                                                                                                                                                                                                        this.mySetDepth = SVNDepth.FILES;
                                                                                                                                                                                                                                                                    } else if (SVNDepth.IMMEDIATES.getName().equals(depth)) {
                                                                                                                                                                                                                                                                        this.mySetDepth = SVNDepth.IMMEDIATES;
                                                                                                                                                                                                                                                                    } else if (SVNDepth.INFINITY.getName().equals(depth)) {
                                                                                                                                                                                                                                                                        this.mySetDepth = SVNDepth.INFINITY;
                                                                                                                                                                                                                                                                    } else if (SVNDepth.EXCLUDE.getName().equals(depth)) {
                                                                                                                                                                                                                                                                        this.mySetDepth = SVNDepth.EXCLUDE;
                                                                                                                                                                                                                                                                    } else {
                                                                                                                                                                                                                                                                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "''{0}'' is not a valid depth; try ''exclude'', ''empty'', ''files'', ''immediates'', or ''infinity''", (Object)depth);
                                                                                                                                                                                                                                                                        SVNErrorManager.error(err, SVNLogType.CLIENT);
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                    break block56;
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                if (option != SVNOption.VERSION) break block75;
                                                                                                                                                                                                                                                                this.myIsVersion = true;
                                                                                                                                                                                                                                                                break block56;
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                            if (option != SVNOption.USERNAME) break block76;
                                                                                                                                                                                                                                                            this.myUserName = optionValue.getValue();
                                                                                                                                                                                                                                                            break block56;
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                        if (option != SVNOption.PASSWORD) break block77;
                                                                                                                                                                                                                                                        this.myPassword = optionValue.getValue();
                                                                                                                                                                                                                                                        break block56;
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                    if (option != SVNOption.ENCODING) break block78;
                                                                                                                                                                                                                                                    this.myEncoding = optionValue.getValue();
                                                                                                                                                                                                                                                    break block56;
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                if (option != SVNOption.XML) break block79;
                                                                                                                                                                                                                                                this.myIsXML = true;
                                                                                                                                                                                                                                                break block56;
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                            if (option != SVNOption.STOP_ON_COPY) break block80;
                                                                                                                                                                                                                                            this.myIsStopOnCopy = true;
                                                                                                                                                                                                                                            break block56;
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                        if (option != SVNOption.STRICT) break block81;
                                                                                                                                                                                                                                        this.myIsStrict = true;
                                                                                                                                                                                                                                        break block56;
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                    if (option != SVNOption.NO_AUTH_CACHE) break block82;
                                                                                                                                                                                                                                    this.myIsNoAuthCache = true;
                                                                                                                                                                                                                                    break block56;
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                if (option != SVNOption.NON_INTERACTIVE) break block83;
                                                                                                                                                                                                                                this.myIsNonInteractive = true;
                                                                                                                                                                                                                                break block56;
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                            if (option != SVNOption.FORCE_INTERACTIVE) break block84;
                                                                                                                                                                                                                            this.myIsForceInteractive = true;
                                                                                                                                                                                                                            break block56;
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                        if (option != SVNOption.NO_DIFF_DELETED) break block85;
                                                                                                                                                                                                                        this.myIsNoDiffDeleted = true;
                                                                                                                                                                                                                        break block56;
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                    if (option != SVNOption.NO_DIFF_ADDED) break block86;
                                                                                                                                                                                                                    this.myIsNoDiffAdded = true;
                                                                                                                                                                                                                    break block56;
                                                                                                                                                                                                                }
                                                                                                                                                                                                                if (option != SVNOption.NOTICE_ANCESTRY) break block87;
                                                                                                                                                                                                                this.myIsNoticeAncestry = true;
                                                                                                                                                                                                                break block56;
                                                                                                                                                                                                            }
                                                                                                                                                                                                            if (option != SVNOption.IGNORE_ANCESTRY) break block88;
                                                                                                                                                                                                            this.myIsIgnoreAncestry = true;
                                                                                                                                                                                                            break block56;
                                                                                                                                                                                                        }
                                                                                                                                                                                                        if (option != SVNOption.SHOW_COPIES_AS_ADDS) break block89;
                                                                                                                                                                                                        this.myIsShowCopiesAsAdds = true;
                                                                                                                                                                                                        break block56;
                                                                                                                                                                                                    }
                                                                                                                                                                                                    if (option != SVNOption.GIT_DIFF_FORMAT) break block90;
                                                                                                                                                                                                    this.myIsGitDiffFormat = true;
                                                                                                                                                                                                    break block56;
                                                                                                                                                                                                }
                                                                                                                                                                                                if (option != SVNOption.PROPERTIES_ONLY) break block91;
                                                                                                                                                                                                this.myIsPropertiesOnly = true;
                                                                                                                                                                                                break block56;
                                                                                                                                                                                            }
                                                                                                                                                                                            if (option != SVNOption.IGNORE_PROPERTIES) break block92;
                                                                                                                                                                                            this.myIsIgnoreProperties = true;
                                                                                                                                                                                            break block56;
                                                                                                                                                                                        }
                                                                                                                                                                                        if (option != SVNOption.REVERSE_DIFF) break block93;
                                                                                                                                                                                        this.myIsReverseDiff = true;
                                                                                                                                                                                        break block56;
                                                                                                                                                                                    }
                                                                                                                                                                                    if (option != SVNOption.IGNORE_WHITESPACE) break block94;
                                                                                                                                                                                    this.myIsIgnoreWhitespace = true;
                                                                                                                                                                                    break block56;
                                                                                                                                                                                }
                                                                                                                                                                                if (option != SVNOption.DIFF) break block95;
                                                                                                                                                                                this.myIsShowDiff = true;
                                                                                                                                                                                break block56;
                                                                                                                                                                            }
                                                                                                                                                                            if (option != SVNOption.IGNORE_EXTERNALS) break block96;
                                                                                                                                                                            this.myIsIgnoreExternals = true;
                                                                                                                                                                            break block56;
                                                                                                                                                                        }
                                                                                                                                                                        if (option != SVNOption.IGNORE_KEYWORDS) break block97;
                                                                                                                                                                        this.myIsIgnoreKeywords = true;
                                                                                                                                                                        break block56;
                                                                                                                                                                    }
                                                                                                                                                                    if (option != SVNOption.RELOCATE) break block98;
                                                                                                                                                                    if (this.myDepth != SVNDepth.UNKNOWN) {
                                                                                                                                                                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, "--depth and --relocate are mutually exclusive"), SVNLogType.CLIENT);
                                                                                                                                                                    }
                                                                                                                                                                    this.myIsRelocate = true;
                                                                                                                                                                    break block56;
                                                                                                                                                                }
                                                                                                                                                                if (option != SVNOption.EXTENSIONS) break block99;
                                                                                                                                                                String extensionsString = optionValue.getValue();
                                                                                                                                                                String[] extensions = extensionsString.trim().split("\\s+");
                                                                                                                                                                if (this.myExtensions == null) {
                                                                                                                                                                    this.myExtensions = new SVNHashSet();
                                                                                                                                                                }
                                                                                                                                                                this.myExtensions.addAll(Arrays.asList(extensions));
                                                                                                                                                                break block56;
                                                                                                                                                            }
                                                                                                                                                            if (option != SVNOption.RECORD_ONLY) break block100;
                                                                                                                                                            this.myIsRecordOnly = true;
                                                                                                                                                            break block56;
                                                                                                                                                        }
                                                                                                                                                        if (option != SVNOption.DIFF_CMD) break block101;
                                                                                                                                                        this.myDiffCommand = optionValue.getValue();
                                                                                                                                                        break block56;
                                                                                                                                                    }
                                                                                                                                                    if (option != SVNOption.EDITOR_CMD) break block102;
                                                                                                                                                    this.myEditorCommand = optionValue.getValue();
                                                                                                                                                    break block56;
                                                                                                                                                }
                                                                                                                                                if (option != SVNOption.OLD) break block103;
                                                                                                                                                if (this.myIsChangeOptionUsed) {
                                                                                                                                                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Can't specify -c with --old"), SVNLogType.CLIENT);
                                                                                                                                                }
                                                                                                                                                this.myOldTarget = optionValue.getValue();
                                                                                                                                                break block56;
                                                                                                                                            }
                                                                                                                                            if (option != SVNOption.NEW) break block104;
                                                                                                                                            this.myNewTarget = optionValue.getValue();
                                                                                                                                            break block56;
                                                                                                                                        }
                                                                                                                                        if (option != SVNOption.CONFIG_DIR) break block105;
                                                                                                                                        this.myConfigDir = optionValue.getValue();
                                                                                                                                        break block56;
                                                                                                                                    }
                                                                                                                                    if (option != SVNOption.CONFIG_OPTION) break block106;
                                                                                                                                    if (this.myConfigOptions == null) {
                                                                                                                                        this.myConfigOptions = new HashMap();
                                                                                                                                    }
                                                                                                                                    if (this.myServersOptions == null) {
                                                                                                                                        this.myServersOptions = new HashMap();
                                                                                                                                    }
                                                                                                                                    SVNCommandUtil.parseConfigOption(optionValue.getValue(), this.myConfigOptions, this.myServersOptions);
                                                                                                                                    break block56;
                                                                                                                                }
                                                                                                                                if (option != SVNOption.AUTOPROPS) break block107;
                                                                                                                                if (this.myIsNoAutoProps) {
                                                                                                                                    SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, "--auto-props and --no-auto-props are mutually exclusive"), SVNLogType.CLIENT);
                                                                                                                                }
                                                                                                                                this.myIsAutoProps = true;
                                                                                                                                break block56;
                                                                                                                            }
                                                                                                                            if (option != SVNOption.NO_AUTOPROPS) break block108;
                                                                                                                            if (this.myIsAutoProps) {
                                                                                                                                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_MUTUALLY_EXCLUSIVE_ARGS, "--auto-props and --no-auto-props are mutually exclusive"), SVNLogType.CLIENT);
                                                                                                                            }
                                                                                                                            this.myIsNoAutoProps = true;
                                                                                                                            break block56;
                                                                                                                        }
                                                                                                                        if (option != SVNOption.NATIVE_EOL) break block109;
                                                                                                                        this.myNativeEOL = optionValue.getValue();
                                                                                                                        break block56;
                                                                                                                    }
                                                                                                                    if (option != SVNOption.NO_UNLOCK) break block110;
                                                                                                                    this.myIsNoUnlock = true;
                                                                                                                    break block56;
                                                                                                                }
                                                                                                                if (option != SVNOption.SUMMARIZE) break block111;
                                                                                                                this.myIsSummarize = true;
                                                                                                                break block56;
                                                                                                            }
                                                                                                            if (option != SVNOption.REMOVE) break block112;
                                                                                                            this.myIsRemove = true;
                                                                                                            break block56;
                                                                                                        }
                                                                                                        if (option != SVNOption.CHANGELIST) break block113;
                                                                                                        this.myChangelist = optionValue.getValue();
                                                                                                        if (this.myChangelist == null) {
                                                                                                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Changelist names must not be empty");
                                                                                                            SVNErrorManager.error(err, SVNLogType.CLIENT);
                                                                                                        }
                                                                                                        this.myChangelists.add(this.myChangelist);
                                                                                                        break block56;
                                                                                                    }
                                                                                                    if (option != SVNOption.KEEP_CHANGELISTS) break block114;
                                                                                                    this.myIsKeepChangelist = true;
                                                                                                    break block56;
                                                                                                }
                                                                                                if (option != SVNOption.KEEP_LOCAL) break block115;
                                                                                                this.myIsKeepLocal = true;
                                                                                                break block56;
                                                                                            }
                                                                                            if (option != SVNOption.NO_IGNORE) break block116;
                                                                                            this.myIsNoIgnore = true;
                                                                                            break block56;
                                                                                        }
                                                                                        if (option != SVNOption.WITH_ALL_REVPROPS) break block117;
                                                                                        this.myIsWithAllRevprops = true;
                                                                                        break block56;
                                                                                    }
                                                                                    if (option != SVNOption.WITH_REVPROP) break block118;
                                                                                    this.parseRevisionProperty(optionValue);
                                                                                    break block56;
                                                                                }
                                                                                if (option != SVNOption.PARENTS) break block119;
                                                                                this.myIsParents = true;
                                                                                break block56;
                                                                            }
                                                                            if (option != SVNOption.USE_MERGE_HISTORY) break block120;
                                                                            this.myIsUseMergeHistory = true;
                                                                            break block56;
                                                                        }
                                                                        if (option != SVNOption.ACCEPT) break block121;
                                                                        SVNConflictAcceptPolicy accept = SVNConflictAcceptPolicy.fromString(optionValue.getValue());
                                                                        if (accept == SVNConflictAcceptPolicy.INVALID) {
                                                                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "''{0}'' is not a valid --accept value;", (Object)optionValue.getValue());
                                                                            SVNErrorManager.error(err, SVNLogType.CLIENT);
                                                                        }
                                                                        this.myResolveAccept = accept;
                                                                        break block56;
                                                                    }
                                                                    if (option != SVNOption.SHOW_REVS) break block122;
                                                                    this.myShowRevsType = SVNShowRevisionType.fromString(optionValue.getValue());
                                                                    if (this.myShowRevsType != SVNShowRevisionType.INVALID) break block56;
                                                                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "''{0}'' is not a valid --show-revs value", (Object)optionValue.getValue());
                                                                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                                                                    break block56;
                                                                }
                                                                if (option != SVNOption.REINTEGRATE) break block123;
                                                                this.myIsReIntegrate = true;
                                                                break block56;
                                                            }
                                                            if (option != SVNOption.ALLOW_MIXED_REVISIONS) break block124;
                                                            this.myIsAllowMixedRevisions = true;
                                                            break block56;
                                                        }
                                                        if (option != SVNOption.AUTHOR_OF_INTEREST) break block125;
                                                        this.myAuthorOfInterest = optionValue.getValue();
                                                        break block56;
                                                    }
                                                    if (option != SVNOption.REGULAR_EXPRESSION) break block126;
                                                    this.myRegularExpression = optionValue.getValue();
                                                    break block56;
                                                }
                                                if (option != SVNOption.TRUST_SERVER_CERT) break block127;
                                                this.myIsTrustServerCertificate = true;
                                                this.myIsTrustServerCertificateFailures = EnumSet.of(SVNCertificateFailureKind.UNKNOWN_CA);
                                                break block56;
                                            }
                                            if (option != SVNOption.TRUST_SERVER_CERT_FAILURES) break block128;
                                            this.myIsTrustServerCertificateFailures = EnumSet.noneOf(SVNCertificateFailureKind.class);
                                            String failuesCommaSeparated = optionValue.getValue();
                                            if (failuesCommaSeparated == null) break block56;
                                            for (String failure : failures = failuesCommaSeparated.split(",")) {
                                                if ((failure = failure.trim()).length() <= 0) continue;
                                                SVNCertificateFailureKind failureKind = SVNCertificateFailureKind.fromString(failure);
                                                if (failureKind != null) {
                                                    this.myIsTrustServerCertificateFailures.add(failureKind);
                                                    continue;
                                                }
                                                SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Unknown value ''{0}'' for {1}.\nSupported values: {2}", failure, "--trust-server-cert-failures", "unknown-ca, cn-mismatch, expired, not-yet-valid, other");
                                                SVNErrorManager.error(errorMessage, SVNLogType.WC);
                                            }
                                            break block56;
                                        }
                                        if (option != SVNOption.SHOW_INHERITED_PROPS) break block129;
                                        this.myIsShowInhertiedProps = true;
                                        break block56;
                                    }
                                    if (option != SVNOption.PIN_EXTERNALS) break block130;
                                    this.myIsPinExternals = true;
                                    break block56;
                                }
                                if (option != SVNOption.REMOVE_UNVERSIONED) break block131;
                                this.myIsRemoveUnversioned = true;
                                break block56;
                            }
                            if (option != SVNOption.REMOVE_IGNORED) break block132;
                            this.myIsRemoveIgnored = true;
                            break block56;
                        }
                        if (option != SVNOption.NO_NEWLINE) break block133;
                        this.myIsNoNewLine = true;
                        break block56;
                    }
                    if (option != SVNOption.SHOW_ITEM) break block134;
                    this.myShowItem = optionValue.getValue();
                    break block56;
                }
                if (option != SVNOption.INCLUDE_EXTERNALS) break block135;
                this.myIsIncludeExternals = true;
                break block56;
            }
            if (option != SVNOption.STRIP) break block56;
            String value = optionValue.getValue();
            try {
                this.myStripCount = Integer.parseInt(optionValue.getValue());
            }
            catch (NumberFormatException nfe) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Non-numeric change argument ({0}) given to -strip", (Object)value);
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
        }
    }

    protected SVNCommand getSVNCommand() {
        return (SVNCommand)this.getCommand();
    }

    @Override
    protected void validateOptions(SVNCommandLine commandLine) throws SVNException {
        SVNErrorMessage err;
        super.validateOptions(commandLine);
        if (!this.isForceLog() && this.getSVNCommand().isCommitter()) {
            File file;
            if (this.myFilePath != null && this.isVersioned(this.myFilePath)) {
                err = SVNErrorMessage.create(SVNErrorCode.CL_LOG_MESSAGE_IS_VERSIONED_FILE, this.getSVNCommand().getFileAmbigousErrorMessage());
                SVNErrorManager.error(err, SVNLogType.CLIENT);
            }
            if (this.myMessage != null && !"".equals(this.myMessage) && SVNFileType.getType(file = new File(this.myMessage).getAbsoluteFile()) != SVNFileType.NONE) {
                SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CL_LOG_MESSAGE_IS_PATHNAME, this.getSVNCommand().getMessageAmbigousErrorMessage());
                SVNErrorManager.error(err2, SVNLogType.CLIENT);
            }
        }
        if (!this.getSVNCommand().acceptsRevisionRange() && this.getEndRevision() != SVNRevision.UNDEFINED) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_REVISION_RANGE);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (!this.myIsDescend) {
            this.myDepth = this.getCommand() instanceof SVNStatusCommand ? SVNDepth.IMMEDIATES : (this.getCommand() instanceof SVNRevertCommand || this.getCommand() instanceof SVNAddCommand || this.getCommand() instanceof SVNCommitCommand ? SVNDepth.EMPTY : SVNDepth.FILES);
        }
        if ("relocate".equals(this.getCommandName())) {
            this.myIsRelocate = true;
        }
    }

    @Override
    protected String getCommandLineClientName() {
        return "svn";
    }

    public boolean isReIntegrate() {
        return this.myIsReIntegrate;
    }

    public SVNShowRevisionType getShowRevisionType() {
        return this.myShowRevsType;
    }

    public boolean isChangeOptionUsed() {
        return this.myIsChangeOptionUsed;
    }

    public boolean isRevisionOptionUsed() {
        return this.myIsRevisionOptionUsed;
    }

    public String getChangelist() {
        return this.myChangelist;
    }

    public String[] getChangelists() {
        if (this.myChangelists != null && !this.myChangelists.isEmpty()) {
            return this.myChangelists.toArray(new String[this.myChangelists.size()]);
        }
        return null;
    }

    public Collection getChangelistsCollection() {
        return this.myChangelists;
    }

    public boolean isIgnoreKeywords() {
        return this.myIsIgnoreKeywords;
    }

    public SVNDepth getDepth() {
        return this.myDepth;
    }

    public SVNDepth getSetDepth() {
        return this.mySetDepth;
    }

    public boolean isVerbose() {
        return this.myIsVerbose;
    }

    public boolean isNoIgnore() {
        return this.myIsNoIgnore;
    }

    public boolean isUpdate() {
        return this.myIsUpdate;
    }

    public boolean isQuiet() {
        return this.myIsQuiet;
    }

    public boolean isIncremental() {
        return this.myIsIncremental;
    }

    public boolean isRevprop() {
        return this.myIsRevprop;
    }

    public boolean isStrict() {
        return this.myIsStrict;
    }

    public List getRevisionRanges() {
        return this.myRevisionRanges;
    }

    public SVNRevision getStartRevision() {
        return this.myStartRevision;
    }

    public SVNRevision getEndRevision() {
        return this.myEndRevision;
    }

    public boolean isXML() {
        return this.myIsXML;
    }

    public boolean isVersion() {
        return this.myIsVersion;
    }

    public boolean isForce() {
        return this.myIsForce;
    }

    public String getEncoding() {
        return this.myEncoding;
    }

    public byte[] getFileData() {
        return this.myFileData;
    }

    public List getTargets() {
        return this.myTargets;
    }

    public boolean isForceLog() {
        return this.myIsForceLog;
    }

    public String getEditorCommand() {
        return this.myEditorCommand;
    }

    public String getDiffCommand() {
        return this.myDiffCommand;
    }

    public String getMessage() {
        return this.myMessage;
    }

    public SVNProperties getRevisionProperties() {
        return this.myRevisionProperties;
    }

    public boolean isDryRun() {
        return this.myIsDryRun;
    }

    public boolean isIgnoreAncestry() {
        return this.myIsIgnoreAncestry;
    }

    public boolean isShowCopiesAsAdds() {
        return this.myIsShowCopiesAsAdds;
    }

    public boolean isGitDiffFormat() {
        return this.myIsGitDiffFormat;
    }

    public boolean isPropertiesOnly() {
        return this.myIsPropertiesOnly;
    }

    public boolean isIgnoreProperties() {
        return this.myIsIgnoreProperties;
    }

    public boolean isReverseDiff() {
        return this.myIsReverseDiff;
    }

    public boolean isIgnoreWhitespace() {
        return this.myIsIgnoreWhitespace;
    }

    public boolean isShowDiff() {
        return this.myIsShowDiff;
    }

    public boolean isUseMergeHistory() {
        return this.myIsUseMergeHistory;
    }

    public boolean isRecordOnly() {
        return this.myIsRecordOnly;
    }

    public Collection getExtensions() {
        return this.myExtensions;
    }

    public String getNativeEOL() {
        return this.myNativeEOL;
    }

    public boolean isRelocate() {
        return this.myIsRelocate;
    }

    public boolean isNoUnlock() {
        return this.myIsNoUnlock;
    }

    public boolean isKeepChangelist() {
        return this.myIsKeepChangelist;
    }

    public boolean isParents() {
        return this.myIsParents;
    }

    public boolean isKeepLocal() {
        return this.myIsKeepLocal;
    }

    public SVNConflictAcceptPolicy getResolveAccept() {
        return this.myResolveAccept;
    }

    public boolean isRemove() {
        return this.myIsRemove;
    }

    public boolean isSummarize() {
        return this.myIsSummarize;
    }

    public boolean isNoticeAncestry() {
        return this.myIsNoticeAncestry;
    }

    public boolean isNoDiffDeleted() {
        return this.myIsNoDiffDeleted;
    }

    public boolean isNoDiffAdded() {
        return this.myIsNoDiffAdded;
    }

    public String getOldTarget() {
        return this.myOldTarget;
    }

    public String getNewTarget() {
        return this.myNewTarget;
    }

    public String getAuthorOfInterest() {
        return this.myAuthorOfInterest;
    }

    public boolean isNoAutoProps() {
        return this.myIsNoAutoProps;
    }

    public String getRegularExpression() {
        return this.myRegularExpression;
    }

    public long getLimit() {
        return this.myLimit;
    }

    public boolean isStopOnCopy() {
        return this.myIsStopOnCopy;
    }

    public boolean isAllRevisionProperties() {
        return this.myIsWithAllRevprops;
    }

    public int getStripCount() {
        return this.myStripCount;
    }

    public SVNDiffOptions getDiffOptions() throws SVNException {
        boolean ignoreEOLStyle;
        boolean ignoreAmountOfWS;
        boolean ignoreAllWS;
        if (this.myExtensions == null) {
            return null;
        }
        LinkedList extensions = new LinkedList(this.myExtensions);
        boolean bl = ignoreAllWS = this.myExtensions.contains("-w") || this.myExtensions.contains("--ignore-all-space");
        if (ignoreAllWS) {
            extensions.remove("-w");
            extensions.remove("--ignore-all-space");
        }
        boolean bl2 = ignoreAmountOfWS = this.myExtensions.contains("-b") || this.myExtensions.contains("--ignore-space-change");
        if (ignoreAmountOfWS) {
            extensions.remove("-b");
            extensions.remove("--ignore-space-change");
        }
        if (ignoreEOLStyle = this.myExtensions.contains("--ignore-eol-style")) {
            extensions.remove("--ignore-eol-style");
        }
        if (!extensions.isEmpty()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INVALID_DIFF_OPTION, "Invalid argument ''{0}'' in diff options", extensions.get(0));
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        return new SVNDiffOptions(ignoreAllWS, ignoreAmountOfWS, ignoreEOLStyle);
    }

    public boolean isAllowMixedRevisions() {
        return this.myIsAllowMixedRevisions;
    }

    public boolean isShowInheritedProps() {
        return this.myIsShowInhertiedProps;
    }

    public String getShowItem() {
        return this.myShowItem;
    }

    public boolean isNoNewLine() {
        return this.myIsNoNewLine;
    }

    public boolean isPinExternals() {
        return this.myIsPinExternals;
    }

    public boolean isRemoveUnversioned() {
        return this.myIsRemoveUnversioned;
    }

    public boolean isRemoveIgnored() {
        return this.myIsRemoveIgnored;
    }

    public boolean isIncludeExternals() {
        return this.myIsIncludeExternals;
    }

    public SVNConflictStats getConflictStats() {
        return this.myConflictStats;
    }

    @Override
    public SVNProperties getRevisionProperties(String message, SVNCommitItem[] commitables, SVNProperties revisionProperties) throws SVNException {
        return revisionProperties == null ? new SVNProperties() : revisionProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCommitMessage(String message, SVNCommitItem[] commitables) throws SVNException {
        if (this.getFileData() != null) {
            byte[] data = this.getFileData();
            for (int i = 0; i < data.length; ++i) {
                if (data[i] != 0) continue;
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.CL_BAD_LOG_MESSAGE, "Log message contains a zero byte"), SVNLogType.CLIENT);
            }
            String charset = this.getEncoding();
            if (charset == null) {
                charset = this.getOptions().getLogEncoding();
            }
            if (charset == null) {
                charset = this.getOptions().getNativeCharset();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStream os = SVNTranslator.getTranslatingOutputStream(bos, charset, new byte[]{10}, false, null, false);
            try {
                os.write(this.getFileData());
                os.close();
                os = null;
                String string = new String(bos.toByteArray(), "UTF-8");
                return string;
            }
            catch (UnsupportedEncodingException e) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage()), SVNLogType.CLIENT);
            }
            catch (IOException e) {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.IO_ERROR, "Error normalizing log message to internal format"), SVNLogType.CLIENT);
            }
            finally {
                SVNFileUtil.closeFile(os);
            }
        } else if (this.getMessage() != null) {
            return this.getMessage();
        }
        if (commitables == null || commitables.length == 0) {
            return "";
        }
        if (this.myIsNonInteractive) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_INSUFFICIENT_ARGS, "Cannot invoke editor to get log message when non-interactive");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        message = null;
        while (message == null) {
            message = this.createCommitMessageTemplate(commitables);
            byte[] messageData = null;
            try {
                try {
                    messageData = message.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    messageData = message.getBytes();
                }
                messageData = SVNCommandUtil.runEditor(this, this.getEditorCommand(), messageData, "svn-commit");
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.CL_NO_EXTERNAL_EDITOR) {
                    SVNErrorMessage err = e.getErrorMessage().wrap("Could not use external editor to fetch log message; consider setting the $SVN_EDITOR environment variable or using the --message (-m) or --file (-F) options");
                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                }
                throw e;
            }
            if (messageData != null) {
                String editedMessage = null;
                try {
                    editedMessage = this.getEncoding() != null ? new String(messageData, this.getEncoding()) : new String(messageData);
                }
                catch (UnsupportedEncodingException e) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getMessage());
                    SVNErrorManager.error(err, SVNLogType.CLIENT);
                }
                if (editedMessage.indexOf(DEFAULT_LOG_MESSAGE_HEADER) >= 0) {
                    editedMessage = editedMessage.substring(0, editedMessage.indexOf(DEFAULT_LOG_MESSAGE_HEADER));
                }
                if (!"a".equals(editedMessage.trim())) {
                    return editedMessage;
                }
            }
            message = null;
            this.getOut().println("\nLog message unchanged or not specified\na)bort, c)ontinue, e)dit");
            try {
                char c = (char)this.getIn().read();
                if (c == 'a') {
                    SVNErrorManager.cancel("", SVNLogType.CLIENT);
                    continue;
                }
                if (c == 'c') {
                    return "";
                }
                if (c != 'e') continue;
            }
            catch (IOException iOException) {}
        }
        SVNErrorManager.cancel("", SVNLogType.CLIENT);
        return null;
    }

    private void parseRevisionProperty(SVNOptionValue optionValue) throws SVNException {
        String revProp;
        if (this.myRevisionProperties == null) {
            this.myRevisionProperties = new SVNProperties();
        }
        if ((revProp = optionValue.getValue()) == null || "".equals(revProp)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CL_ARG_PARSING_ERROR, "Revision property pair is empty");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        int index = revProp.indexOf(61);
        String revPropName = null;
        String revPropValue = null;
        if (index >= 0) {
            revPropName = revProp.substring(0, index);
            revPropValue = revProp.substring(index + 1);
        } else {
            revPropName = revProp;
            revPropValue = "";
        }
        if (!SVNPropertiesManager.isValidPropertyName(revPropName)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_PROPERTY_NAME, "''{0}'' is not a valid Subversion property name", (Object)revPropName);
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        this.myRevisionProperties.put(revPropName, revPropValue);
    }

    private String createCommitMessageTemplate(SVNCommitItem[] items) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(System.getProperty("line.separator"));
        buffer.append(DEFAULT_LOG_MESSAGE_HEADER);
        buffer.append(System.getProperty("line.separator"));
        buffer.append(System.getProperty("line.separator"));
        for (int i = 0; i < items.length; ++i) {
            String path;
            SVNCommitItem item = items[i];
            String string = path = item.getPath() != null ? item.getPath() : item.getURL().toString();
            if ("".equals(path) || path == null) {
                path = ".";
            }
            if (item.isDeleted() && item.isAdded()) {
                buffer.append('R');
            } else if (item.isDeleted()) {
                buffer.append('D');
            } else if (item.isAdded()) {
                buffer.append('A');
            } else if (item.isContentsModified()) {
                buffer.append('M');
            } else {
                buffer.append('_');
            }
            if (item.isPropertiesModified()) {
                buffer.append('M');
            } else {
                buffer.append(' ');
            }
            if (!this.myIsNoUnlock && item.isLocked()) {
                buffer.append('L');
            } else {
                buffer.append(' ');
            }
            if (item.isCopied()) {
                buffer.append("+ ");
            } else {
                buffer.append("  ");
            }
            buffer.append(path);
            buffer.append(System.getProperty("line.separator"));
        }
        return buffer.toString();
    }
}

