/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import sun.misc.Unsafe;

class PackIndexV2m
extends PackIndex {
    private static final long IS_O64 = 0x80000000L;
    private static final int FANOUT = 256;
    private static final Unsafe UNSAFE;
    private final byte[] idBuf = new byte[20];
    private final Thread ownerThread = Thread.currentThread();
    private final long objectCnt;
    private final long namesOffset;
    private final long crc32Offset;
    private final long offsets32Offset;
    private final long offsets64Offset;
    private final long hashOffset;
    private final long[] fanoutTable;
    private FileChannel channel;
    private RandomAccessFile raFile;
    private MappedByteBuffer buffer;

    PackIndexV2m(File file) throws IOException {
        this.raFile = new RandomAccessFile(file, "r");
        this.channel = this.raFile.getChannel();
        try {
            this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.raFile.length());
        }
        catch (IOException ex) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.raFile.close();
            throw ex;
        }
        this.buffer.get(new byte[8]);
        this.fanoutTable = new long[256];
        for (int k = 0; k < 256; ++k) {
            this.fanoutTable[k] = Integer.toUnsignedLong(this.buffer.getInt());
        }
        this.objectCnt = this.fanoutTable[255];
        this.packChecksum = new byte[20];
        this.namesOffset = 1032L;
        this.crc32Offset = this.namesOffset + this.objectCnt * 20L;
        this.offsets32Offset = this.crc32Offset + this.objectCnt * 4L;
        this.offsets64Offset = this.offsets32Offset + this.objectCnt * 4L;
        this.hashOffset = (int)this.channel.size() - 40;
        this.buffer.position((int)this.hashOffset);
        this.buffer.get(this.packChecksum, 0, this.packChecksum.length);
    }

    @Override
    public long getObjectCount() {
        return this.objectCnt;
    }

    @Override
    public long getOffset64Count() {
        return (this.hashOffset - this.offsets64Offset) / 8L;
    }

    @Override
    public ObjectId getObjectId(long nthPosition) {
        this.assertThread();
        return ObjectId.fromRaw(this.readNameShared(nthPosition));
    }

    @Override
    public long getOffset(long nthPosition) {
        this.assertThread();
        long offset32 = Integer.toUnsignedLong(this.buffer.getInt(this.toBufferPos(this.offsets32Offset, nthPosition, 4)));
        if ((offset32 & 0x80000000L) == 0L) {
            return offset32;
        }
        return this.buffer.getLong(this.toBufferPos(this.offsets64Offset, offset32 & 0xFFFFFFFF7FFFFFFFL, 8));
    }

    @Override
    public long findOffset(AnyObjectId objId) {
        this.assertThread();
        long objIndex = this.findObjectIndex(objId);
        if (objIndex == -1L) {
            return -1L;
        }
        return this.getOffset(objIndex);
    }

    @Override
    public long findCRC32(AnyObjectId objId) throws MissingObjectException {
        this.assertThread();
        long objIndex = this.findObjectIndex(objId);
        if (objIndex == -1L) {
            throw new MissingObjectException(objId.copy(), "unknown");
        }
        return Integer.toUnsignedLong(this.buffer.getInt(this.toBufferPos(this.crc32Offset, objIndex, 4)));
    }

    @Override
    public boolean hasCRC32Support() {
        return true;
    }

    @Override
    public Iterator<PackIndex.MutableEntry> iterator() {
        this.assertThread();
        return new EntriesIteratorV2();
    }

    @Override
    public void resolve(Set<ObjectId> matches, AbbreviatedObjectId id, int matchLimit) throws IOException {
        int levelOne;
        long end = this.fanoutTable[levelOne];
        long start = (levelOne = id.getFirstByte()) > 0 ? this.fanoutTable[levelOne - 1] : 0L;
        long bucketCnt = end - start;
        int high = (int)bucketCnt;
        if (high == 0) {
            return;
        }
        int low = 0;
        do {
            int mid;
            int cmp;
            if ((cmp = id.prefixCompare(this.readNameShared(start + (long)(mid = low + high >>> 1)), 0)) < 0) {
                high = mid;
                continue;
            }
            if (cmp == 0) {
                while (0 < mid && id.prefixCompare(this.readNameShared(start + (long)mid - 1L), 0) == 0) {
                    --mid;
                }
                while ((long)mid < bucketCnt && id.prefixCompare(this.readNameShared(start + (long)mid), 0) == 0) {
                    matches.add(ObjectId.fromRaw(this.readNameShared(start + (long)mid)));
                    if (matches.size() > matchLimit) break;
                    ++mid;
                }
                return;
            }
            low = mid + 1;
        } while (low < high);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        PackIndexV2m packIndexV2m = this;
        synchronized (packIndexV2m) {
            if (this.buffer != null) {
                UNSAFE.invokeCleaner(this.buffer);
                this.buffer = null;
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.channel = null;
            }
            if (this.raFile != null) {
                try {
                    this.raFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.raFile = null;
            }
        }
    }

    private long findObjectIndex(AnyObjectId objId) {
        int levelOne = objId.getFirstByte();
        int levelTwo = this.binarySearchLevelTwo(objId, levelOne);
        if (levelTwo == -1) {
            return -1L;
        }
        return (levelOne > 0 ? this.fanoutTable[levelOne - 1] : 0L) + (long)levelTwo;
    }

    private int toBufferPos(long offset, long objectIndex, int rowSize) {
        long pos = offset + objectIndex * (long)rowSize;
        if (pos > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Buffer position " + pos + " is too large for JGit.");
        }
        return (int)pos;
    }

    private int binarySearchLevelTwo(AnyObjectId objId, int levelOne) {
        long end = this.fanoutTable[levelOne];
        long start = levelOne > 0 ? this.fanoutTable[levelOne - 1] : 0L;
        long bucketCnt = end - start;
        int high = (int)bucketCnt;
        if (high == 0) {
            return -1;
        }
        int low = 0;
        do {
            int mid;
            int cmp;
            if ((cmp = objId.compareTo(this.readNameShared(start + (long)(mid = low + high >>> 1)), 0)) < 0) {
                high = mid;
                continue;
            }
            if (cmp == 0) {
                return mid;
            }
            low = mid + 1;
        } while (low < high);
        return -1;
    }

    private byte[] readNameShared(long objectIndex) {
        this.buffer.position(this.toBufferPos(this.namesOffset, objectIndex, 20));
        this.buffer.get(this.idBuf);
        return this.idBuf;
    }

    private void assertThread() {
        if (Thread.currentThread() != this.ownerThread) {
            throw new AssertionError((Object)("bad thread access (current=" + Thread.currentThread() + ",owner=" + this.ownerThread + ")"));
        }
    }

    static {
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            UNSAFE = (Unsafe)f.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private class EntriesIteratorV2
    extends PackIndex.EntriesIterator {
        private long objIndex = -1L;

        private EntriesIteratorV2() {
        }

        @Override
        protected PackIndex.MutableEntry initEntry() {
            return new PackIndex.MutableEntry(){

                @Override
                protected void ensureId() {
                    this.idBuffer.fromRaw(PackIndexV2m.this.readNameShared(EntriesIteratorV2.this.objIndex));
                }
            };
        }

        @Override
        public PackIndex.MutableEntry next() {
            ++this.objIndex;
            if (this.objIndex < PackIndexV2m.this.objectCnt) {
                this.entry.offset = PackIndexV2m.this.getOffset(this.objIndex);
                ++this.returnedNumber;
                return this.entry;
            }
            throw new NoSuchElementException();
        }
    }
}

