/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html.renderer;

import com.vladsch.flexmark.ast.AutoLink;
import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.ast.BulletList;
import com.vladsch.flexmark.ast.BulletListItem;
import com.vladsch.flexmark.ast.Code;
import com.vladsch.flexmark.ast.CodeBlock;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Emphasis;
import com.vladsch.flexmark.ast.FencedCodeBlock;
import com.vladsch.flexmark.ast.HardLineBreak;
import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlBlock;
import com.vladsch.flexmark.ast.HtmlBlockBase;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.HtmlEntity;
import com.vladsch.flexmark.ast.HtmlInline;
import com.vladsch.flexmark.ast.HtmlInlineBase;
import com.vladsch.flexmark.ast.HtmlInlineComment;
import com.vladsch.flexmark.ast.HtmlInnerBlock;
import com.vladsch.flexmark.ast.HtmlInnerBlockComment;
import com.vladsch.flexmark.ast.Image;
import com.vladsch.flexmark.ast.ImageRef;
import com.vladsch.flexmark.ast.IndentedCodeBlock;
import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.LinkRef;
import com.vladsch.flexmark.ast.ListItem;
import com.vladsch.flexmark.ast.MailLink;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.ast.NonRenderingInline;
import com.vladsch.flexmark.ast.OrderedList;
import com.vladsch.flexmark.ast.OrderedListItem;
import com.vladsch.flexmark.ast.Paragraph;
import com.vladsch.flexmark.ast.ParagraphItemContainer;
import com.vladsch.flexmark.ast.Reference;
import com.vladsch.flexmark.ast.SoftLineBreak;
import com.vladsch.flexmark.ast.StrongEmphasis;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ast.TextBase;
import com.vladsch.flexmark.ast.ThematicBreak;
import com.vladsch.flexmark.ast.util.LineCollectingVisitor;
import com.vladsch.flexmark.ast.util.ReferenceRepository;
import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.HtmlRendererOptions;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.Escaping;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.Range;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CoreNodeRenderer
implements NodeRenderer {
    public static final AttributablePart LOOSE_LIST_ITEM = new AttributablePart("LOOSE_LIST_ITEM");
    public static final AttributablePart TIGHT_LIST_ITEM = new AttributablePart("TIGHT_LIST_ITEM");
    public static final AttributablePart PARAGRAPH_LINE = new AttributablePart("PARAGRAPH_LINE");
    public static final AttributablePart CODE_CONTENT = new AttributablePart("FENCED_CODE_CONTENT");
    private final ListOptions listOptions;
    private final boolean obfuscateEmail;
    private final boolean obfuscateEmailRandom;
    private final ReferenceRepository referenceRepository;
    private final boolean recheckUndefinedReferences;
    private final boolean codeContentBlock;
    private final boolean codeSoftLineBreaks;
    private List<Range> myLines;
    private List<Integer> myEOLs;
    private int myNextLine;
    private int nextLineStartOffset;

    public CoreNodeRenderer(DataHolder options) {
        this.referenceRepository = (ReferenceRepository)((Object)options.get(Parser.REFERENCES));
        this.listOptions = ListOptions.getFrom(options);
        this.recheckUndefinedReferences = (Boolean)HtmlRenderer.RECHECK_UNDEFINED_REFERENCES.getFrom(options);
        this.obfuscateEmail = (Boolean)HtmlRenderer.OBFUSCATE_EMAIL.getFrom(options);
        this.obfuscateEmailRandom = (Boolean)HtmlRenderer.OBFUSCATE_EMAIL_RANDOM.getFrom(options);
        this.codeContentBlock = (Boolean)Parser.FENCED_CODE_CONTENT_BLOCK.getFrom(options);
        this.codeSoftLineBreaks = (Boolean)Parser.CODE_SOFT_LINE_BREAKS.getFrom(options);
        this.myLines = null;
        this.myEOLs = null;
        this.myNextLine = 0;
        this.nextLineStartOffset = 0;
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        return new HashSet(Arrays.asList(new NodeRenderingHandler<AutoLink>(AutoLink.class, new CustomNodeRenderer<AutoLink>(){

            @Override
            public void render(AutoLink node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<BlockQuote>(BlockQuote.class, new CustomNodeRenderer<BlockQuote>(){

            @Override
            public void render(BlockQuote node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<BulletList>(BulletList.class, new CustomNodeRenderer<BulletList>(){

            @Override
            public void render(BulletList node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Code>(Code.class, new CustomNodeRenderer<Code>(){

            @Override
            public void render(Code node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<CodeBlock>(CodeBlock.class, new CustomNodeRenderer<CodeBlock>(){

            @Override
            public void render(CodeBlock node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Document>(Document.class, new CustomNodeRenderer<Document>(){

            @Override
            public void render(Document node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Emphasis>(Emphasis.class, new CustomNodeRenderer<Emphasis>(){

            @Override
            public void render(Emphasis node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<FencedCodeBlock>(FencedCodeBlock.class, new CustomNodeRenderer<FencedCodeBlock>(){

            @Override
            public void render(FencedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HardLineBreak>(HardLineBreak.class, new CustomNodeRenderer<HardLineBreak>(){

            @Override
            public void render(HardLineBreak node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Heading>(Heading.class, new CustomNodeRenderer<Heading>(){

            @Override
            public void render(Heading node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlBlock>(HtmlBlock.class, new CustomNodeRenderer<HtmlBlock>(){

            @Override
            public void render(HtmlBlock node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlCommentBlock>(HtmlCommentBlock.class, new CustomNodeRenderer<HtmlCommentBlock>(){

            @Override
            public void render(HtmlCommentBlock node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlInnerBlock>(HtmlInnerBlock.class, new CustomNodeRenderer<HtmlInnerBlock>(){

            @Override
            public void render(HtmlInnerBlock node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlInnerBlockComment>(HtmlInnerBlockComment.class, new CustomNodeRenderer<HtmlInnerBlockComment>(){

            @Override
            public void render(HtmlInnerBlockComment node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlEntity>(HtmlEntity.class, new CustomNodeRenderer<HtmlEntity>(){

            @Override
            public void render(HtmlEntity node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlInline>(HtmlInline.class, new CustomNodeRenderer<HtmlInline>(){

            @Override
            public void render(HtmlInline node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<HtmlInlineComment>(HtmlInlineComment.class, new CustomNodeRenderer<HtmlInlineComment>(){

            @Override
            public void render(HtmlInlineComment node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Image>(Image.class, new CustomNodeRenderer<Image>(){

            @Override
            public void render(Image node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<ImageRef>(ImageRef.class, new CustomNodeRenderer<ImageRef>(){

            @Override
            public void render(ImageRef node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<IndentedCodeBlock>(IndentedCodeBlock.class, new CustomNodeRenderer<IndentedCodeBlock>(){

            @Override
            public void render(IndentedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Link>(Link.class, new CustomNodeRenderer<Link>(){

            @Override
            public void render(Link node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<LinkRef>(LinkRef.class, new CustomNodeRenderer<LinkRef>(){

            @Override
            public void render(LinkRef node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<BulletListItem>(BulletListItem.class, new CustomNodeRenderer<BulletListItem>(){

            @Override
            public void render(BulletListItem node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<OrderedListItem>(OrderedListItem.class, new CustomNodeRenderer<OrderedListItem>(){

            @Override
            public void render(OrderedListItem node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<MailLink>(MailLink.class, new CustomNodeRenderer<MailLink>(){

            @Override
            public void render(MailLink node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<OrderedList>(OrderedList.class, new CustomNodeRenderer<OrderedList>(){

            @Override
            public void render(OrderedList node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Paragraph>(Paragraph.class, new CustomNodeRenderer<Paragraph>(){

            @Override
            public void render(Paragraph node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Reference>(Reference.class, new CustomNodeRenderer<Reference>(){

            @Override
            public void render(Reference node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<SoftLineBreak>(SoftLineBreak.class, new CustomNodeRenderer<SoftLineBreak>(){

            @Override
            public void render(SoftLineBreak node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<StrongEmphasis>(StrongEmphasis.class, new CustomNodeRenderer<StrongEmphasis>(){

            @Override
            public void render(StrongEmphasis node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<Text>(Text.class, new CustomNodeRenderer<Text>(){

            @Override
            public void render(Text node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<TextBase>(TextBase.class, new CustomNodeRenderer<TextBase>(){

            @Override
            public void render(TextBase node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        }), new NodeRenderingHandler<ThematicBreak>(ThematicBreak.class, new CustomNodeRenderer<ThematicBreak>(){

            @Override
            public void render(ThematicBreak node, NodeRendererContext context, HtmlWriter html) {
                CoreNodeRenderer.this.render(node, context, html);
            }
        })));
    }

    private void render(Document node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren((Node)node);
    }

    private void render(final Heading node, final NodeRendererContext context, final HtmlWriter html) {
        String id;
        if (context.getHtmlOptions().renderHeaderId && (id = context.getNodeId((Node)node)) != null) {
            html.attr("id", id);
        }
        if (context.getHtmlOptions().sourcePositionParagraphLines) {
            html.srcPos(node.getChars()).withAttr().tagLine("h" + node.getLevel(), new Runnable(){

                @Override
                public void run() {
                    html.srcPos(node.getText()).withAttr().tag("span");
                    context.renderChildren((Node)node);
                    html.tag("/span");
                }
            });
        } else {
            html.srcPos(node.getText()).withAttr().tagLine("h" + node.getLevel(), new Runnable(){

                @Override
                public void run() {
                    context.renderChildren((Node)node);
                }
            });
        }
    }

    private void render(final BlockQuote node, final NodeRendererContext context, HtmlWriter html) {
        html.withAttr().tagLineIndent("blockquote", new Runnable(){

            @Override
            public void run() {
                context.renderChildren((Node)node);
            }
        });
    }

    private void render(FencedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        html.line();
        ((HtmlWriter)html.srcPosWithTrailingEOL(node.getChars()).withAttr().tag("pre")).openPre();
        BasedSequence info = node.getInfo();
        if (info.isNotNull() && !info.isBlank()) {
            int space = info.indexOf(' ');
            BasedSequence language = space == -1 ? info : info.subSequence(0, space);
            html.attr("class", context.getHtmlOptions().languageClassPrefix + language.unescape());
        } else {
            String noLanguageClass = context.getHtmlOptions().noLanguageClass.trim();
            if (!noLanguageClass.isEmpty()) {
                html.attr("class", noLanguageClass);
            }
        }
        html.srcPosWithEOL(node.getContentChars()).withAttr(CODE_CONTENT).tag("code");
        if (this.codeContentBlock) {
            context.renderChildren((Node)node);
        } else {
            html.text(node.getContentChars().normalizeEOL());
        }
        html.tag("/code");
        ((HtmlWriter)html.tag("/pre")).closePre();
        html.lineIf(context.getHtmlOptions().htmlBlockCloseTagEol);
    }

    private void render(ThematicBreak node, NodeRendererContext context, HtmlWriter html) {
        html.srcPos(node.getChars()).withAttr().tagVoidLine("hr");
    }

    private void render(IndentedCodeBlock node, NodeRendererContext context, HtmlWriter html) {
        html.line();
        ((HtmlWriter)html.srcPosWithEOL(node.getChars()).withAttr().tag("pre")).openPre();
        String noLanguageClass = context.getHtmlOptions().noLanguageClass.trim();
        if (!noLanguageClass.isEmpty()) {
            html.attr("class", noLanguageClass);
        }
        html.srcPosWithEOL(node.getContentChars()).withAttr(CODE_CONTENT).tag("code");
        if (this.codeContentBlock) {
            context.renderChildren((Node)node);
        } else {
            html.text(node.getContentChars().trimTailBlankLines().normalizeEndWithEOL());
        }
        html.tag("/code");
        ((HtmlWriter)html.tag("/pre")).closePre();
        html.lineIf(context.getHtmlOptions().htmlBlockCloseTagEol);
    }

    private void render(CodeBlock node, NodeRendererContext context, HtmlWriter html) {
        if (node.getParent() instanceof IndentedCodeBlock) {
            html.text(node.getContentChars().trimTailBlankLines().normalizeEndWithEOL());
        } else {
            html.text(node.getContentChars().normalizeEOL());
        }
    }

    private void render(final BulletList node, final NodeRendererContext context, HtmlWriter html) {
        html.withAttr().tagIndent("ul", new Runnable(){

            @Override
            public void run() {
                context.renderChildren((Node)node);
            }
        });
    }

    private void render(final OrderedList node, final NodeRendererContext context, HtmlWriter html) {
        int start = node.getStartNumber();
        if (this.listOptions.isOrderedListManualStart() && start != 1) {
            html.attr("start", String.valueOf(start));
        }
        html.withAttr().tagIndent("ol", new Runnable(){

            @Override
            public void run() {
                context.renderChildren((Node)node);
            }
        });
    }

    private void render(BulletListItem node, NodeRendererContext context, HtmlWriter html) {
        this.renderListItem(node, context, html);
    }

    private void render(OrderedListItem node, NodeRendererContext context, HtmlWriter html) {
        this.renderListItem(node, context, html);
    }

    private void renderListItem(final ListItem node, final NodeRendererContext context, final HtmlWriter html) {
        if (this.listOptions.isTightListItem(node)) {
            ((HtmlWriter)html.srcPosWithEOL(node.getChars()).withAttr(TIGHT_LIST_ITEM).withCondIndent()).tagLine("li", new Runnable(){

                @Override
                public void run() {
                    html.text(node.getMarkerSuffix().unescape());
                    context.renderChildren((Node)node);
                }
            });
        } else {
            html.srcPosWithEOL(node.getChars()).withAttr(LOOSE_LIST_ITEM).tagIndent("li", new Runnable(){

                @Override
                public void run() {
                    html.text(node.getMarkerSuffix().unescape());
                    context.renderChildren((Node)node);
                }
            });
        }
    }

    public void renderTextBlockParagraphLines(final Paragraph node, final NodeRendererContext context, HtmlWriter html, boolean wrapTextInSpan) {
        if (context.getHtmlOptions().sourcePositionParagraphLines && node.hasChildren()) {
            LineCollectingVisitor breakCollectingVisitor = new LineCollectingVisitor();
            this.myLines = breakCollectingVisitor.collectAndGetRanges((Node)node);
            this.myEOLs = breakCollectingVisitor.getEOLs();
            this.myNextLine = 0;
            this.outputSourceLineSpan((Node)node, node.getFirstChild(), (Node)node, html);
            context.renderChildren((Node)node);
            html.tag("/span");
            return;
        }
        if (wrapTextInSpan) {
            html.withAttr().tag("span", false, false, new Runnable(){

                @Override
                public void run() {
                    context.renderChildren((Node)node);
                }
            });
        } else {
            context.renderChildren((Node)node);
        }
    }

    private void outputSourceLineSpan(Node parentNode, Node startNode, Node endNode, HtmlWriter html) {
        int startOffset = startNode.getStartOffset();
        Range range = this.myLines.get(this.myNextLine);
        int eolLength = this.myEOLs.get(this.myNextLine);
        int endOffset = endNode.getEndOffset();
        if (range.getEnd() <= endOffset) {
            endOffset = range.getEnd();
            endOffset -= eolLength;
            endOffset -= parentNode.getChars().baseSubSequence(startOffset, endOffset).countTrailing((CharSequence)" \t");
            ++this.myNextLine;
            this.nextLineStartOffset = range.getEnd();
            this.nextLineStartOffset += parentNode.getChars().baseSubSequence(this.nextLineStartOffset, parentNode.getChars().getEndOffset()).countLeading((CharSequence)" \t");
        }
        if (range.getStart() > startOffset) {
            startOffset = range.getStart();
        }
        html.srcPos(startOffset, endOffset).withAttr(PARAGRAPH_LINE).tag("span");
    }

    private void outputNextLineBreakSpan(Node node, HtmlWriter html, boolean outputBreakText) {
        Range range = this.myLines.get(this.myNextLine);
        int eolLength = this.myEOLs.get(this.myNextLine);
        ++this.myNextLine;
        int countTrailing = node.getChars().baseSubSequence(this.nextLineStartOffset, range.getEnd() - eolLength).countTrailing((CharSequence)" \t");
        if (!outputBreakText && countTrailing > 0) {
            --countTrailing;
        }
        html.srcPos(this.nextLineStartOffset, range.getEnd() - (eolLength += countTrailing)).withAttr(PARAGRAPH_LINE).tag("span");
        this.nextLineStartOffset = range.getEnd();
        this.nextLineStartOffset += node.getChars().baseSubSequence(this.nextLineStartOffset, node.getChars().getBaseSequence().length()).countLeading((CharSequence)" \t");
    }

    private void renderLooseParagraph(final Paragraph node, final NodeRendererContext context, final HtmlWriter html) {
        html.srcPosWithEOL(node.getChars()).withAttr().tagLine("p", new Runnable(){

            @Override
            public void run() {
                CoreNodeRenderer.this.renderTextBlockParagraphLines(node, context, html, false);
            }
        });
    }

    private void render(Paragraph node, NodeRendererContext context, HtmlWriter html) {
        if (node.getFirstChildAnyNot(new Class[]{NonRenderingInline.class}) != null) {
            if (!(node.getParent() instanceof ParagraphItemContainer) || !((ParagraphItemContainer)node.getParent()).isParagraphWrappingDisabled(node, this.listOptions, context.getOptions())) {
                this.renderLooseParagraph(node, context, html);
            } else {
                this.renderTextBlockParagraphLines(node, context, html, false);
            }
        }
    }

    private boolean renderLineBreak(String breakText, String suppressInTag, Node node, NodeRendererContext context, HtmlWriter html) {
        if (this.myLines != null && this.myNextLine < this.myLines.size()) {
            boolean outputBreakText;
            List openTags = html.getOpenTagsAfterLast("span");
            int iMax = openTags.size();
            boolean bl = outputBreakText = iMax == 0 || suppressInTag == null || !suppressInTag.equalsIgnoreCase((String)openTags.get(iMax - 1));
            if (!outputBreakText && !html.isPendingSpace()) {
                html.raw(" ");
            }
            int i = iMax;
            while (i-- > 0) {
                html.closeTag((CharSequence)openTags.get(i));
            }
            html.tag("/span");
            if (outputBreakText) {
                html.raw(breakText);
            }
            this.outputNextLineBreakSpan(node, html, outputBreakText);
            for (i = 0; i < iMax; ++i) {
                if (!outputBreakText && context.getHtmlOptions().inlineCodeSpliceClass != null && !context.getHtmlOptions().inlineCodeSpliceClass.isEmpty()) {
                    ((HtmlWriter)html.attr("class", context.getHtmlOptions().inlineCodeSpliceClass)).withAttr().tag((CharSequence)openTags.get(i));
                    continue;
                }
                html.tag((CharSequence)openTags.get(i));
            }
            return true;
        }
        return false;
    }

    private void render(SoftLineBreak node, NodeRendererContext context, HtmlWriter html) {
        String softBreak = context.getHtmlOptions().softBreak;
        if (context.getHtmlOptions().sourcePositionParagraphLines && this.renderLineBreak(softBreak, softBreak.equals("\n") || softBreak.equals("\r\n") || softBreak.equals("\r") ? "code" : null, node, context, html)) {
            return;
        }
        html.raw(softBreak);
    }

    private void render(HardLineBreak node, NodeRendererContext context, HtmlWriter html) {
        if (context.getHtmlOptions().sourcePositionParagraphLines && this.renderLineBreak(context.getHtmlOptions().hardBreak, null, node, context, html)) {
            return;
        }
        html.raw(context.getHtmlOptions().hardBreak);
    }

    private void render(Emphasis node, NodeRendererContext context, HtmlWriter html) {
        HtmlRendererOptions htmlOptions = context.getHtmlOptions();
        if (htmlOptions.emphasisStyleHtmlOpen == null || htmlOptions.emphasisStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag("em");
            } else {
                html.srcPos(node.getText()).withAttr().tag("em");
            }
            context.renderChildren(node);
            html.tag("/em");
        } else {
            html.raw(htmlOptions.emphasisStyleHtmlOpen);
            context.renderChildren(node);
            html.raw(htmlOptions.emphasisStyleHtmlClose);
        }
    }

    private void render(StrongEmphasis node, NodeRendererContext context, HtmlWriter html) {
        HtmlRendererOptions htmlOptions = context.getHtmlOptions();
        if (htmlOptions.strongEmphasisStyleHtmlOpen == null || htmlOptions.strongEmphasisStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag("strong");
            } else {
                html.srcPos(node.getText()).withAttr().tag("strong");
            }
            context.renderChildren(node);
            html.tag("/strong");
        } else {
            html.raw(htmlOptions.strongEmphasisStyleHtmlOpen);
            context.renderChildren(node);
            html.raw(htmlOptions.strongEmphasisStyleHtmlClose);
        }
    }

    private void render(Text node, NodeRendererContext context, HtmlWriter html) {
        html.text(Escaping.normalizeEOL((CharSequence)node.getChars().unescape()));
    }

    private void render(TextBase node, NodeRendererContext context, HtmlWriter html) {
        context.renderChildren(node);
    }

    private void render(Code node, NodeRendererContext context, HtmlWriter html) {
        HtmlRendererOptions htmlOptions = context.getHtmlOptions();
        if (htmlOptions.codeStyleHtmlOpen == null || htmlOptions.codeStyleHtmlClose == null) {
            if (context.getHtmlOptions().sourcePositionParagraphLines) {
                html.withAttr().tag("code");
            } else {
                html.srcPos(node.getText()).withAttr().tag("code");
            }
            if (this.codeSoftLineBreaks && !htmlOptions.isSoftBreakAllSpaces) {
                for (Node child : node.getChildren()) {
                    if (child instanceof Text) {
                        html.text(Escaping.collapseWhitespace((CharSequence)child.getChars(), (boolean)true));
                        continue;
                    }
                    context.render(child);
                }
            } else {
                html.text(Escaping.collapseWhitespace((CharSequence)node.getText(), (boolean)true));
            }
            html.tag("/code");
        } else {
            html.raw(htmlOptions.codeStyleHtmlOpen);
            if (this.codeSoftLineBreaks && !htmlOptions.isSoftBreakAllSpaces) {
                for (Node child : node.getChildren()) {
                    if (child instanceof Text) {
                        html.text(Escaping.collapseWhitespace((CharSequence)child.getChars(), (boolean)true));
                        continue;
                    }
                    context.render(child);
                }
            } else {
                html.text(Escaping.collapseWhitespace((CharSequence)node.getText(), (boolean)true));
            }
            html.raw(htmlOptions.codeStyleHtmlClose);
        }
    }

    private void render(HtmlBlock node, NodeRendererContext context, HtmlWriter html) {
        html.line();
        if (context.getHtmlOptions().sourceWrapHtmlBlocks) {
            ((HtmlWriter)((HtmlWriter)html.srcPos(node.getChars()).withAttr(AttributablePart.NODE_POSITION).tag("div")).indent()).line();
        }
        if (node.hasChildren()) {
            context.renderChildren((Node)node);
        } else {
            this.renderHtmlBlock(node, context, html, context.getHtmlOptions().suppressHtmlBlocks, context.getHtmlOptions().escapeHtmlBlocks, false);
        }
        if (context.getHtmlOptions().sourceWrapHtmlBlocks) {
            ((HtmlWriter)html.unIndent()).tag("/div");
        }
        html.lineIf(context.getHtmlOptions().htmlBlockCloseTagEol);
    }

    private void render(HtmlCommentBlock node, NodeRendererContext context, HtmlWriter html) {
        this.renderHtmlBlock(node, context, html, context.getHtmlOptions().suppressHtmlCommentBlocks, context.getHtmlOptions().escapeHtmlCommentBlocks, false);
    }

    private void render(HtmlInnerBlock node, NodeRendererContext context, HtmlWriter html) {
        this.renderHtmlBlock(node, context, html, context.getHtmlOptions().suppressHtmlBlocks, context.getHtmlOptions().escapeHtmlBlocks, false);
    }

    private void render(HtmlInnerBlockComment node, NodeRendererContext context, HtmlWriter html) {
        this.renderHtmlBlock(node, context, html, context.getHtmlOptions().suppressHtmlCommentBlocks, context.getHtmlOptions().escapeHtmlCommentBlocks, false);
    }

    public void renderHtmlBlock(HtmlBlockBase node, NodeRendererContext context, HtmlWriter html, boolean suppress, boolean escape, boolean trimSpaces) {
        String normalizeEOL;
        if (suppress) {
            return;
        }
        if (node instanceof HtmlBlock) {
            html.line();
        }
        String string = normalizeEOL = node instanceof HtmlBlock ? node.getContentChars().normalizeEOL() : node.getChars().normalizeEOL();
        if (trimSpaces) {
            normalizeEOL = normalizeEOL.trim();
        }
        if (escape) {
            if (node instanceof HtmlBlock) {
                if (normalizeEOL.length() > 0 && normalizeEOL.charAt(normalizeEOL.length() - 1) == '\n') {
                    normalizeEOL = normalizeEOL.substring(0, normalizeEOL.length() - 1);
                }
                ((HtmlWriter)((HtmlWriter)html.raw("<p>")).text(normalizeEOL)).raw("</p>");
            } else {
                html.text(normalizeEOL);
            }
        } else {
            html.rawPre(normalizeEOL);
        }
        if (node instanceof HtmlBlock) {
            html.lineIf(context.getHtmlOptions().htmlBlockCloseTagEol);
        }
    }

    private void render(HtmlInline node, NodeRendererContext context, HtmlWriter html) {
        this.renderInlineHtml(node, context, html, context.getHtmlOptions().suppressInlineHtml, context.getHtmlOptions().escapeInlineHtml);
    }

    private void render(HtmlInlineComment node, NodeRendererContext context, HtmlWriter html) {
        this.renderInlineHtml(node, context, html, context.getHtmlOptions().suppressInlineHtmlComments, context.getHtmlOptions().escapeInlineHtmlComments);
    }

    public void renderInlineHtml(HtmlInlineBase node, NodeRendererContext context, HtmlWriter html, boolean suppress, boolean escape) {
        if (suppress) {
            return;
        }
        if (escape) {
            html.text(node.getChars().normalizeEOL());
        } else {
            html.rawPre(node.getChars().normalizeEOL());
        }
    }

    private void render(Reference node, NodeRendererContext context, HtmlWriter html) {
    }

    private void render(HtmlEntity node, NodeRendererContext context, HtmlWriter html) {
        if (context.getHtmlOptions().unescapeHtmlEntities) {
            html.text(node.getChars().unescape());
        } else {
            html.raw(node.getChars().unescapeNoEntities());
        }
    }

    public static boolean isSuppressedLinkPrefix(CharSequence url, NodeRendererContext context) {
        Pattern suppressedLinks = context.getHtmlOptions().suppressedLinks;
        if (suppressedLinks != null) {
            Matcher matcher = suppressedLinks.matcher(url);
            return matcher.matches();
        }
        return false;
    }

    private void render(AutoLink node, NodeRendererContext context, final HtmlWriter html) {
        final String text = node.getText().toString();
        if (context.isDoNotRenderLinks() || CoreNodeRenderer.isSuppressedLinkPrefix((CharSequence)node.getUrl(), context)) {
            html.text(text);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, text, null);
            ((HtmlWriter)html.srcPos(node.getText()).attr("href", resolvedLink.getUrl().startsWith("www.") ? context.getHtmlOptions().autolinkWwwPrefix + resolvedLink.getUrl() : resolvedLink.getUrl())).withAttr(resolvedLink).tag("a", false, false, new Runnable(){

                @Override
                public void run() {
                    html.text(text);
                }
            });
        }
    }

    private void render(MailLink node, NodeRendererContext context, HtmlWriter html) {
        String text = node.getText().unescape();
        if (context.isDoNotRenderLinks() || CoreNodeRenderer.isSuppressedLinkPrefix((CharSequence)node.getUrl(), context)) {
            html.text(text);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, text, null);
            if (this.obfuscateEmail) {
                String url = Escaping.obfuscate((String)("mailto:" + resolvedLink.getUrl()), (boolean)this.obfuscateEmailRandom);
                text = Escaping.obfuscate((String)text, (boolean)true);
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.srcPos(node.getText()).attr("href", url)).withAttr(resolvedLink).tag("a")).raw(text)).tag("/a");
            } else {
                String url = resolvedLink.getUrl();
                ((HtmlWriter)((HtmlWriter)((HtmlWriter)html.srcPos(node.getText()).attr("href", "mailto:" + url)).withAttr(resolvedLink).tag("a")).text(text)).tag("/a");
            }
        }
    }

    private void render(Image node, NodeRendererContext context, HtmlWriter html) {
        if (!context.isDoNotRenderLinks() && !CoreNodeRenderer.isSuppressedLinkPrefix((CharSequence)node.getUrl(), context)) {
            String altText = new TextCollectingVisitor().collectAndGetText(node);
            ResolvedLink resolvedLink = context.resolveLink(LinkType.IMAGE, node.getUrl().unescape(), null, null);
            String url = resolvedLink.getUrl();
            if (!node.getUrlContent().isEmpty()) {
                String content = Escaping.percentEncodeUrl((CharSequence)node.getUrlContent()).replace("+", "%2B").replace("%3D", "=").replace("%26", "&amp;");
                url = url + content;
            }
            html.attr("src", url);
            html.attr("alt", altText);
            if (node.getTitle().isNotNull()) {
                resolvedLink.getNonNullAttributes().replaceValue((CharSequence)"title", (CharSequence)node.getTitle().unescape());
            } else {
                resolvedLink.getNonNullAttributes().remove((CharSequence)"title");
            }
            html.attr(resolvedLink.getAttributes());
            html.srcPos(node.getChars()).withAttr(resolvedLink).tagVoid("img");
        }
    }

    private void render(Link node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks() || CoreNodeRenderer.isSuppressedLinkPrefix((CharSequence)node.getUrl(), context)) {
            context.renderChildren(node);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, node.getUrl().unescape(), null, null);
            html.attr("href", resolvedLink.getUrl());
            if (node.getTitle().isNotNull()) {
                resolvedLink.getNonNullAttributes().replaceValue((CharSequence)"title", (CharSequence)node.getTitle().unescape());
            } else {
                resolvedLink.getNonNullAttributes().remove((CharSequence)"title");
            }
            html.attr(resolvedLink.getAttributes());
            html.srcPos(node.getChars()).withAttr(resolvedLink).tag("a");
            this.renderChildrenSourceLineWrapped(node, node.getText(), context, html);
            html.tag("/a");
        }
    }

    private void renderChildrenSourceLineWrapped(Node node, BasedSequence nodeChildText, NodeRendererContext context, HtmlWriter html) {
        if (context.getHtmlOptions().sourcePositionParagraphLines && nodeChildText.indexOfAny((CharSequence)"\r\n") >= 0) {
            if (this.myNextLine > 0) {
                --this.myNextLine;
            }
            this.outputSourceLineSpan(node, node, node, html);
            context.renderChildren(node);
            html.tag("/span");
        } else {
            context.renderChildren(node);
        }
    }

    private void render(ImageRef node, NodeRendererContext context, HtmlWriter html) {
        ResolvedLink resolvedLink = null;
        boolean isSuppressed = false;
        if (!node.isDefined() && this.recheckUndefinedReferences && node.getReferenceNode(this.referenceRepository) != null) {
            node.setDefined(true);
        }
        Reference reference = null;
        if (node.isDefined()) {
            reference = node.getReferenceNode(this.referenceRepository);
            String url = reference.getUrl().unescape();
            isSuppressed = CoreNodeRenderer.isSuppressedLinkPrefix(url, context);
            resolvedLink = context.resolveLink(LinkType.IMAGE, url, null, null);
            if (reference.getTitle().isNotNull()) {
                resolvedLink.getNonNullAttributes().replaceValue((CharSequence)"title", (CharSequence)reference.getTitle().unescape());
            } else {
                resolvedLink.getNonNullAttributes().remove((CharSequence)"title");
            }
        } else {
            String normalizeRef = this.referenceRepository.normalizeKey((CharSequence)node.getReference());
            resolvedLink = context.resolveLink(LinkType.IMAGE_REF, normalizeRef, null, null);
            if (resolvedLink.getStatus() == LinkStatus.UNKNOWN) {
                resolvedLink = null;
            }
        }
        if (resolvedLink == null) {
            html.text(node.getChars().unescape());
        } else if (!context.isDoNotRenderLinks() && !isSuppressed) {
            String altText = new TextCollectingVisitor().collectAndGetText(node);
            Attributes attributes = resolvedLink.getNonNullAttributes();
            html.attr("src", resolvedLink.getUrl());
            html.attr("alt", altText);
            if (reference != null) {
                attributes = context.extendRenderingNodeAttributes(reference, AttributablePart.NODE, attributes);
            }
            html.attr(attributes);
            html.srcPos(node.getChars()).withAttr(resolvedLink).tagVoid("img");
        }
    }

    private void render(LinkRef node, NodeRendererContext context, HtmlWriter html) {
        ResolvedLink resolvedLink = null;
        boolean isSuppressed = false;
        if (!node.isDefined() && this.recheckUndefinedReferences && node.getReferenceNode(this.referenceRepository) != null) {
            node.setDefined(true);
        }
        Reference reference = null;
        if (node.isDefined()) {
            reference = node.getReferenceNode(this.referenceRepository);
            String url = reference.getUrl().unescape();
            isSuppressed = CoreNodeRenderer.isSuppressedLinkPrefix(url, context);
            resolvedLink = context.resolveLink(LinkType.LINK, url, null, null);
            if (reference.getTitle().isNotNull()) {
                resolvedLink.getNonNullAttributes().replaceValue((CharSequence)"title", (CharSequence)reference.getTitle().unescape());
            } else {
                resolvedLink.getNonNullAttributes().remove((CharSequence)"title");
            }
        } else {
            String normalizeRef = node.getReference().unescape();
            resolvedLink = context.resolveLink(LinkType.LINK_REF, normalizeRef, null, null);
            if (resolvedLink.getStatus() == LinkStatus.UNKNOWN) {
                resolvedLink = null;
            }
        }
        if (resolvedLink == null) {
            assert (!node.isDefined());
            if (!node.hasChildren()) {
                html.text(node.getChars().unescape());
            } else {
                html.text(node.getChars().prefixOf(node.getChildChars()).unescape());
                this.renderChildrenSourceLineWrapped(node, node.getText(), context, html);
                html.text(node.getChars().suffixOf(node.getChildChars()).unescape());
            }
        } else if (context.isDoNotRenderLinks() || isSuppressed) {
            context.renderChildren(node);
        } else {
            Attributes attributes = resolvedLink.getNonNullAttributes();
            html.attr("href", resolvedLink.getUrl());
            if (reference != null) {
                attributes = context.extendRenderingNodeAttributes(reference, AttributablePart.NODE, attributes);
            }
            html.attr(attributes);
            html.srcPos(node.getChars()).withAttr(resolvedLink).tag("a");
            this.renderChildrenSourceLineWrapped(node, node.getText(), context, html);
            html.tag("/a");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        public NodeRenderer create(DataHolder options) {
            return new CoreNodeRenderer(options);
        }
    }
}

