/*
 * Decompiled with CFR 0.152.
 */
package org.snakeyaml.engine.v1.api;

import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.snakeyaml.engine.v1.api.DumpSettings;
import org.snakeyaml.engine.v1.api.StreamDataWriter;
import org.snakeyaml.engine.v1.api.StreamToStringWriter;
import org.snakeyaml.engine.v1.emitter.Emitter;
import org.snakeyaml.engine.v1.nodes.Node;
import org.snakeyaml.engine.v1.representer.BaseRepresenter;
import org.snakeyaml.engine.v1.representer.StandardRepresenter;
import org.snakeyaml.engine.v1.serializer.Serializer;

public class Dump {
    private DumpSettings settings;
    private BaseRepresenter representer;

    public Dump(DumpSettings settings) {
        this(settings, new StandardRepresenter(settings));
    }

    public Dump(DumpSettings settings, BaseRepresenter representer) {
        Objects.requireNonNull(settings, "DumpSettings cannot be null");
        Objects.requireNonNull(representer, "Representer cannot be null");
        this.settings = settings;
        this.representer = representer;
    }

    public void dumpAll(Iterator<? extends Object> instancesIterator, StreamDataWriter streamDataWriter) {
        Serializer serializer = new Serializer(this.settings, new Emitter(this.settings, streamDataWriter));
        serializer.open();
        while (instancesIterator.hasNext()) {
            Object instance = instancesIterator.next();
            Node node = this.representer.represent(instance);
            serializer.serialize(node);
        }
        serializer.close();
    }

    public void dump(Object yaml, StreamDataWriter streamDataWriter) {
        Iterator<Object> iter = Collections.singleton(yaml).iterator();
        this.dumpAll(iter, streamDataWriter);
    }

    public String dumpAllToString(Iterator<? extends Object> instancesIterator) {
        StreamToStringWriter writer = new StreamToStringWriter();
        this.dumpAll(instancesIterator, writer);
        return writer.toString();
    }

    public String dumpToString(Object yaml) {
        StreamToStringWriter writer = new StreamToStringWriter();
        this.dump(yaml, writer);
        return writer.toString();
    }
}

